/*------------------------------------------------------------------------------*
 * File Name: image_utils.c	 													*
 * Creation: 2005-07-20															*
 * Purpose: image utility functions												*
 * Copyright (c) OriginLab Corp. 2005											*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 * EJP 2005-11-07 DRAG_DROP_FALSE_ERR_MESSAGE									*
 * EJP 2005-11-14 v8.0336 QA70-8247 COLOR_IMAGE_SHOW_WRONG_ORDER				*
 * EJP 2006-02-16 v8.0366 MOVE_IMPORT_FILE_INFO_FROM_OC_TO_VC					*
 * EJP 2006-03-10 v8.0374 MAKE_SURE_VIEW_PERSPECTIVE_IS_TOP_LEFT				*
 * EJP 2006-03-14 v8.0375 SUPPORT_ROI_IN_IMAGE_PROCESSING						*
 * EJP 2006-05-10 v8.0387 QA70-8187 GET_DATA_VALUES_DIRECT_FROM_IMAGE			*
 *	CPY 5/10/06 USE_MAT_CACHE_FOR_PROFILE										*
 * Sandy 2006-7-26 FIX_HISTOGRAM_BUG_ABOUT_JPG									*
 *	CPY 8/11/06 IMAGE_OPEN_DLG_MOVED_TO_GETN									*
 *  SY 2006-11-01 v8.0503 ADD_ALL_FILES											*
 * EJP 2006-11-06 v8.0506 LOAD_RGB_ORDER_AS_BGR_ORDER_FOR_PROPER_DISPLAY		*
 * EJP 2006-11-17 v8.0513 MAT_EXPORT_IMAGE_NEED_RANGE_STR_TO_INDICATE_WHICH_MATRIX
 * EJP 2006-11-20 v8.0514 FIX_EXPORT_MATRIX_RET_VAL								*
 * EJP 2006-11-21 v8.0514 IMPROVE_IMG_EXT_TYPE_UTIL_FUNC						*
 * Iris 11/21/06 TEMP_CODES_TO_ONLY_SUPPORT_PARTIAL_IMAGE_TYPE_FOR_EXPORT		*
 * Iris 12/05/06 NOT_SUPPORT_DPI_FOR_TGA_GIF									*
 * EJP 2007-02-01 v8.0553 QA70-9329 FILE_EXT_GRP_ALL_TYPES						*
 * Sim 06-21-2007 GET_EXTENSION_LIST_OF_IMAGE_TYPE								*
 * Sim 06-29-2007 THEME_MECHANISM_INSTEAD_OF_INI_SETTING						*
 * EJP 2007-07-02 v8.0653 QA70-9939 SAVEAS_PATH_NEED_UPDATE_OPEN_PATH			*
 * Sim 07-04-2007 FIX_IMAGE_SETTING_TREE_NODE_EVENT								*
 * Iris 07/12/2007 PAGE_RESOLUTION_SHOULD_BE_DIFF_WITH_IMAGE_RESOLUTION			*
 * Iris 07/12/2007 v8.0658 NO_LABEL_FOR_RADIO_BUTTON							*
 * Sim 08-01-2007 ADD_MORE_COLOR_BIT_FOR_EXPORT_IMAGE							*
 * Sim 08-09-2007 MAKE_EPS_INI_SETING_SAME_AS_75								*
 * EJP 2007-08-09 v8.0679 USE_CORRECT_KEY_NAMES_USED_BY_OIMG					*
 * Sim 08-22-2007 MAKE_IMAGE_TYPE_LIST_SORTED_BY_EXT							*
 * Sim 08-30-2007 FIX_COLOR_NAME												*
 * EJP 2007-09-06 v8.0698 QA70-10350 LOAD_RGB_ORDER_AS_BGR_ORDER_FOR_PROPER_DISPLAY
 * Hong 10/25/07 QA80-10577 MORE_COMBO_STR_STAY_AS_E_INTERNALLY_IN_DYNA_CNTRL	*
 * EJP 2009-07-14 QA80-13532 NEED_OL_DELETE_BITMAP_FOR_OL_NEW_BITMAP			*
 *	Kenny 07/21/2009 QA80-13980 CLEAN_UP_AND_IMPROVE_XF_IMP_IMAGE_TO_TWO_SEPARATE_XF*
 *------------------------------------------------------------------------------*/
 
////////////////////////////////////////////////////////////////////////////////////
// Including the system header file Origin.h should be sufficient for most Origin
// applications and is recommended. Origin.h includes many of the most common system
// header files and is automatically pre-compiled when Origin runs the first time.
// Programs including Origin.h subsequently compile much more quickly as long as
// the size and number of other included header files is minimized. All NAG header
// files are now included in Origin.h and no longer need be separately included.
//
// Right-click on the line below and select 'Open "Origin.h"' to open the Origin.h
// system header file.
#include <Origin.h>
//#include <OcImgLT.h>
#include <image_utils.h>

////////////////////////////////////////////////////////////////////////////////////
#include <okocUtils.h> //CPY 5/10/06 USE_MAT_CACHE_FOR_PROFILE

#include <oErrMsg.h> //Sandy 2006-8-14

#include <GetNBox.h> /// Iris 11/17/06 MOVE_EXPORT_PAGE_CODE_AS_GLOBAL_FROM_XF
//#include <..\Originlab\grobj_utils.h> ///---Sim 12-11-2006 GET_IMAGE_LINE_PROFILE not use again
#include <..\Originlab\matdata_utils.h>


#define	SHOW_TIME(_str)	// show_time(_str)//---- CPY 4/23/07 GRAPH_EXPORT_SPEED_TESTING

//----- CPY 10/23/2007 QA70-10577 COMBO_STR_STAY_AS_E_INTERNALLY_IN_DYNA_CNTRL
#define GETN_COLOR_DEPATH_TRUE_8GRAY	 GETN_STRLIST_L(BitsPerPixel, _L("Color Depth"), "24-bit Color", _LE("24-bit Color|8-bit Gray Scale"))
#define GETN_COLOR_DEPATH_BASIC 		 GETN_STRLIST_L(BitsPerPixel, _L("Color Depth"), "256 Colors", _LE("Monochrome|16 Colors|256 Colors|8-bit Gray Scale"))
#define GETN_COLOR_DEPATH_TRUECOLOR 	 GETN_STRLIST_L(BitsPerPixel, _L("Color Depth"), "256 Colors", _LE("Monochrome|16 Colors|256 Colors|24-bit Color|8-bit Gray Scale"))
#define GETN_COLOR_DEPATH_TRUECOLOR_NO16 GETN_STRLIST_L(BitsPerPixel, _L("Color Depth"), "256 Colors", _LE("Monochrome|256 Colors|24-bit Color|8-bit Gray Scale"))

#define GETN_COLOR_DEPATH_65536COLORS 		 GETN_STRLIST_L(BitsPerPixel, _L("Color Depth"), "256 Colors", _LE("Monochrome|16 Colors|256 Colors|16-bit Color|24-bit Color|8-bit Gray Scale"))
#define GETN_COLOR_DEPATH_65536COLORS_NOMONO GETN_STRLIST_L(BitsPerPixel, _L("Color Depth"), "256 Colors", _LE("256 Colors|16-bit Color|24-bit Color|8-bit Gray Scale"))
//----- end COMBO_STR_STAY_AS_E_INTERNALLY_IN_DYNA_CNTRL


/// EJP 2006-03-14 v8.0375 SUPPORT_ROI_IN_IMAGE_PROCESSING
LPVOID copy_ROI_from_LeadBitmap(LPVOID pLBmp, GraphObject &grROI)
{
	pBITMAPHANDLE pLBmpROI = ol_new_bitmap();
	if( pLBmpROI )
	{
		// L_COPY_BITMAP_RECT(_pBitmapDst, _pBitmapSrc, _nCol, _nRow, _uWidth, _uHeight)
		int x 	= (int) (grROI.X - grROI.DX / 2);
		int y 	= (int) (grROI.Y - grROI.DY / 2);
		int cx 	= (int) (grROI.X + grROI.DX / 2) - x + 1;
		int cy 	= (int) (grROI.Y + grROI.DY / 2) - y + 1;
		if( SUCCESS != L_COPY_BITMAP_RECT(pLBmpROI, (pBITMAPHANDLE)pLBmp, x, y, cx, cy) )
		{
			/// EJP 2009-07-14 QA80-13532 NEED_OL_DELETE_BITMAP_FOR_OL_NEW_BITMAP
			///L_FreeBitmap(pLBmpROI);
			ol_delete_bitmap(pLBmpROI);
			/// end NEED_OL_DELETE_BITMAP_FOR_OL_NEW_BITMAP
			pLBmpROI = NULL;
		}
	}
	return pLBmpROI;
}

BOOL set_ROI_in_LeadBitmap(LPVOID pLBmp, vector<point> *pROI)
{
	/*
	L_INT EXT_FUNCTION L_SetBitmapRgnPolygon(
		pBITMAPHANDLE pBitmap,	// pointer to the bitmap handle
		pRGNXFORM pXForm,		// pointer to a coordinate-translation structure
		POINT L_FAR * pPoints,	// pointer to an array of POINT structures
		L_UINT uPoints,			// number of points in the array
		L_UINT uFillMode,		// indicates how to handle complex crossing lines
		L_UINT uCombineMode);	// action to take regarding the existing region
	*/
	RGNXFORM xfrm;
	xfrm.uViewPerspective = TOP_LEFT;
	xfrm.nXScalarNum = 1;
	xfrm.nXScalarDen = 1;
	xfrm.nYScalarNum = 1;
	xfrm.nYScalarDen = 1;
	xfrm.nXOffset = 0;
	xfrm.nYOffset = 0;
	
	LPVOID pvoid = *pROI;
	POINT* pPts = (POINT*)pvoid;

	if( SUCCESS == L_SetBitmapRgnPolygon((pBITMAPHANDLE)pLBmp, &xfrm, pPts, pROI->GetSize(), 0/*L_POLY_WINDING*/, 1/*L_RGN_SET*/) )
		return TRUE;
	return FALSE;
}
/// end SUPPORT_ROI_IN_IMAGE_PROCESSING
//---- CPY 11/20/06 BRING_BACK_IMAGE_IMPORT_INTO_GRAPH
// Import images into active layer as graphic objects
///---Sim 12-23-2006 PUBLIC_IMPORT_IMAGE_TO_GRAPH_UTILITY_FUNCTION
//static bool image_import_to_active_layer(LPCSTR lpcszFile)
#ifndef __CLEAN_UP_AND_IMPROVE_XF_IMP_IMAGE_TO_TWO_SEPARATE_XF	/// Kenny 07/21/2009 QA80-13980 CLEAN_UP_AND_IMPROVE_XF_IMP_IMAGE_TO_TWO_SEPARATE_XF
bool image_import_to_active_graph_layer(LPCSTR lpcszFile)
///---END PUBLIC_IMPORT_IMAGE_TO_GRAPH_UTILITY_FUNCTION
{
	string str;
	str.Format("Image.FileName$=%s;", lpcszFile);
	LT_execute(str);
	LT_execute("run.section(imgfile.ogs,LoadImageIntoGrObject);");
	return true;
}
/// Kenny 07/21/2009 QA80-13980 CLEAN_UP_AND_IMPROVE_XF_IMP_IMAGE_TO_TWO_SEPARATE_XF
#else
bool image_import_to_active_graph_layer(LPCSTR lpcszFile, int nX /*= -1*/, int nY /*= -1*/)
{
	string str;
	str.Format("Image.FileName$=%s;Image.Import.X=%d;Image.Import.Y=%d;", lpcszFile, nX, nY);
	LT_execute(str);
	LT_execute("run.section(imgfile.ogs,LoadImageIntoGrObject);");
	return true;
}
#endif
/// End QA80-13980 CLEAN_UP_AND_IMPROVE_XF_IMP_IMAGE_TO_TWO_SEPARATE_XF

int image_dlg_import_to_active_page()
{
	int nRet = -1;
	string strFile;
	if( image_file_dlg(GetWindow(), strFile, _L("Import Image"), true) )
	{
		GraphPage pgTarget = Project.Pages();
		if( pgTarget )
		{
			// Import images into active layer as graphic objects
			if( image_import_to_active_graph_layer(strFile) ) ///---Sim 12-23-2006 PUBLIC_IMPORT_IMAGE_TO_GRAPH_UTILITY_FUNCTION
				nRet = 0;
		}
	}
	return nRet; // 0 == success, non-zero == error
}
//---- end BRING_BACK_IMAGE_IMPORT_INTO_GRAPH

//---- CPY 8/11/06 IMAGE_OPEN_DLG_MOVED_TO_GETN
/*
/// EJP 2005-07-15 v8.0268 QA70-7891 ACCESS_LEADTOOLS_FROM_OC
int image_dlg_import_to_active_page()
{
	int nRet = -1;

	StringArray saFiles;
	if( image_file_dlg(GetWindow(), saFiles, _L("Import Image"), true, true) )
	{
		MatrixPage pgTarget = Project.Pages();
		if( pgTarget )
		{
			if( image_import_to_matrix_sheets(pgTarget, saFiles) )
				nRet = 0;
		}
		else
		{
			// Import images into active layer as graphic objects
			if( image_import_to_active_layer(saFiles) )
				nRet = 0;
		}
	}
	return nRet; // 0 == success, non-zero == error
}

static bool image_import_to_matrix_sheets(MatrixPage& pgTarget, StringArray& saFiles)
{
	MatrixLayer mlTarget;
	int nLayer;
	
	int nFile;
	for( nFile = 0; nFile < saFiles.GetSize(); nFile++ )
	{
		if( nFile )
		{
			// Import additional files into new sheets
			nLayer = pgTarget.AddLayer();
			if( -1 == nLayer )
				break;
		}
		else
			nLayer = -1; // Import first file into active sheet
		
		mlTarget = pgTarget.Layers(nLayer);
		if( !mlTarget )
			break;
		image_import_to_matrix_sheet(mlTarget, saFiles[nFile]);
	}
	
	return (nFile == saFiles.GetSize());
}

int image_import_to_active_matrix(string lpcszFile)
{
	MatrixLayer ml = Project.ActiveLayer();
	if( ml )
	{
		if( SUCCESS == image_import_to_matrix_sheet(ml, lpcszFile) )
		{
			/// EJP 2006-05-17 v8.0412, moved to inside 'image_import_to_matrix_sheet'
			return 0; // success
			/// end
		}
	}
	return 1; // failure
}
static int image_import_to_matrix_sheet(MatrixLayer& mlTarget, LPCSTR lpcszFile)
{
	MatrixObject moTarget;
	moTarget = mlTarget.MatrixObjects();
	/// EJP 2005-11-07 DRAG_DROP_FALSE_ERR_MESSAGE
	///if(moTarget)
	///	return image_import_to_matrix(moTarget, lpcszFile);
	///
	///return -2;
	if( moTarget && image_import_to_matrix(moTarget, lpcszFile) )
	{
		string strFileName = GetFileName(lpcszFile, TRUE);
		mlTarget.SetName(strFileName, OCD_LONG_NAME | OCD_ENUM_NEXT);
		
		Page pg = mlTarget.GetPage();
		if( pg )
		{
//			pg.Label = lpcszFile;
//			pg.TitleShow = WIN_TITLE_SHOW_BOTH;
			okutil_SetPageInfo(pg.GetName(), lpcszFile, 1); // 1 = Binary data type
		}
		return SUCCESS;
	}
	return FAILURE;
	/// end DRAG_DROP_FALSE_ERR_MESSAGE
}

*/

//----- CPY 10/5/05 IMREAD_XF
/*
int image_import_to_matrix(MatrixLayer& mlTarget, LPCSTR lpcszFile)
{
	BITMAPHANDLE bh;
	int nRet = L_LOADBITMAP(lpcszFile, &bh, 0, ORDER_BGR, NULL);
	if( SUCCESS == nRet )
	{
		MatrixObject moTarget;
		moTarget = mlTarget.MatrixObjects();
		nRet = _ChangeLeadBitmapToMatrixObjectDIB(moTarget, &bh);
		if( SUCCESS != nRet )
			L_FreeBitmap(&bh);
		
		Page pg = mlTarget.GetPage();
		if( pg )
			pg.LT_execute("page -f;");
	}
	return nRet;
}
*/
///---Sim 08-09-2006 HANDLE_FILTER_AND_FILE_INFO
//bool image_import_to_matrix(MatrixObject& moTarget, LPCSTR lpcszFile, int* pErr = NULL)
bool image_import_to_matrix(MatrixObject& moTarget, LPCSTR lpcszFile, TreeNode &trFileInfo, TreeNode &trFilter, int* pErr)//=NULL,=NULL, = NULL)
///---END HANDLE_FILTER_AND_FILE_INFO
{
	pBITMAPHANDLE pLBmp = ol_new_bitmap();
	if( NULL == pLBmp )
		return false;
	
	///2006-7-26 Sandy FIX_HISTOGRAM_BUG_ABOUT_JPG 
	FILEINFO fi;
	if( SUCCESS != L_FILE_INFO(lpcszFile, &fi, 0, NULL) )
	{
		ol_delete_bitmap(pLBmp); /// EJP 2009-07-14 QA80-13532 NEED_OL_DELETE_BITMAP_FOR_OL_NEW_BITMAP
		return false;
	}
	/// EJP 2007-09-06 v8.0698 QA70-10350 LOAD_RGB_ORDER_AS_BGR_ORDER_FOR_PROPER_DISPLAY
	///	int nRet = L_LOADBITMAP(lpcszFile, pLBmp, 0, fi.Order, NULL);
	int nOrder = fi.Order;
	if( fi.BitsPerPixel >= 16 && nOrder == ORDER_RGB )
		nOrder = ORDER_BGR;
	int nRet = L_LOADBITMAP(lpcszFile, pLBmp, 0, nOrder, NULL);
	/// end LOAD_RGB_ORDER_AS_BGR_ORDER_FOR_PROPER_DISPLAY

	//	int nRet = L_LOADBITMAP(lpcszFile, pLBmp, 0, fi.Order, NULL);
	//int nRet = L_LOADBITMAP(lpcszFile, pLBmp, 0, ORDER_BGRORGRAYORROMM, NULL);
	/// end COLOR_IMAGE_SHOW_WRONG_ORDER
	/// end FIX_HISTOGRAM_BUG_ABOUT_JPG
	
	/// end LEAD_BITMAP_GR_OBJ 
	if( SUCCESS == nRet )
	{
		if(trFileInfo) //CPY 9/13/06 BRING_BACK_IMGREAD_XF
		{
			/// AW 08/09/06 MORE_ON_IMP_IMAGE
			TreeNode trHeader = tree_check_get_node(trFileInfo, IMPTREE_NODE_HEADER);
			trHeader = fi;
			/// END MORE_ON_IMP_IMAGE
			
			///---Sim 08-11-2006 REMOVE_NODE_OF_GLOBAL_PALETTE_FOR_SHOW_HEAD_FAST
			TreeNode tn = trHeader.GetNode("GlobalPalette");
			///---Sim 08-11-2006 REMOVE_NODE_BECAUSE_SHOW_SLOW_TOO
			//trFileInfo.AddNode(tn);
			//trFileInfo.GlobalPalette.Show = 0;
			///---REMOVE_NODE_BECAUSE_SHOW_SLOW_TOO
			tn.Remove();
			///---END REMOVE_NODE_OF_GLOBAL_PALETTE_FOR_SHOW_HEAD_FAST
		}
		
		/// EJP 2006-03-10 v8.0374 MAKE_SURE_VIEW_PERSPECTIVE_IS_TOP_LEFT
		if( TOP_LEFT != pLBmp->ViewPerspective )
		{
			pBITMAPHANDLE pLBmpTmp = ol_new_bitmap();
			if( pLBmpTmp )
			{
				if( SUCCESS == L_CHANGE_VIEW_PERSPECTIVE(pLBmpTmp, pLBmp, TOP_LEFT) )
				{
					/// EJP 2009-07-14 QA80-13532 NEED_OL_DELETE_BITMAP_FOR_OL_NEW_BITMAP
					///L_FreeBitmap(pLBmp);
					ol_delete_bitmap(pLBmp);
					/// end NEED_OL_DELETE_BITMAP_FOR_OL_NEW_BITMAP
					pLBmp = pLBmpTmp;
				}
				else
				{
					/// EJP 2009-07-14 QA80-13532 NEED_OL_DELETE_BITMAP_FOR_OL_NEW_BITMAP
					///L_FreeBitmap(pLBmpTmp);
					ol_delete_bitmap(pLBmpTmp);
					/// end NEED_OL_DELETE_BITMAP_FOR_OL_NEW_BITMAP
				}
			}
		}
		/// end MAKE_SURE_VIEW_PERSPECTIVE_IS_TOP_LEFT

		/// EJP 2005-10-31 v8.0326 QA70-8186 LEAD_BITMAP_GR_OBJ 
		///nRet = _ChangeLeadBitmapToMatrixObjectDIB(moTarget, &bh);
		///if( SUCCESS != nRet )
		///	L_FreeBitmap(&bh);
		if( !moTarget.SetLeadBitmap(pLBmp, false, true) ) // false = do not make copy, use what we loaded.
		{
			ol_delete_bitmap(pLBmp); /// EJP 2009-07-14 QA80-13532 NEED_OL_DELETE_BITMAP_FOR_OL_NEW_BITMAP
			nRet = FAILURE;
		}
		/// end LEAD_BITMAP_GR_OBJ
		//--- CPY 9/11/06 IMG_IMPORT_TO_1ST_MATOBJ_AND_RENAME_USING_EXT
		//string strNewName = GetFileName(lpcszFile, TRUE);
		//if( !strNewName.IsEmpty() )
		//	moTarget.SetLongName(strNewName);
		// since we already use file name for sheet, better make use of ext to name obj
		string strFilename;
		string strExt;
		separate_file_name_ext(lpcszFile, &strFilename, &strExt);
		if(!strExt.IsEmpty())
			moTarget.SetName(strExt, OCD_LONG_NAME | OCD_ENUM_NEXT);
		//---
	}
	/// EJP 2009-07-14 QA80-13532 NEED_OL_DELETE_BITMAP_FOR_OL_NEW_BITMAP
	else
		ol_delete_bitmap(pLBmp);
	/// end NEED_OL_DELETE_BITMAP_FOR_OL_NEW_BITMAP

	if(pErr)
		*pErr = nRet;
	/// EJP 2005-11-07 DRAG_DROP_FALSE_ERR_MESSAGE
	///return false;
	return (SUCCESS == nRet);
	/// end DRAG_DROP_FALSE_ERR_MESSAGE
}


///Sophy 6/18/2010 ORg-339 MULTIFRAME_TIFF_IMPORT
enum {
	IMP_ERROR_INVALID_OBJ = -500,
	IMP_ERROR_INCONSISTENT_DIMS,
	IMP_ERROR_SET_BITMAP_FAIL,
	IMP_ERROR_COPY_BITMAP_FAIL,
	IMP_NO_ERROR = 0,
};
static int _image_to_matrix(MatrixObject& moTarget, pHBITMAPLIST phList, int ii)
{
	if ( !moTarget || NULL == phList )
		return IMP_ERROR_INVALID_OBJ;
	
	pBITMAPHANDLE phBitmap = ol_new_bitmap();
	if ( NULL == phBitmap )
		return IMP_ERROR_INVALID_OBJ;
	L_GET_BITMAP_LIST_ITEM(*phList, ii, phBitmap);
	///Sophy 6/22/2010 ORG-339 IGNORE_SUBSEQUENT_FRAMES_IF_INCONSISTENT_RESOLUTION
	if ( ii > 0 )
	{
		int nCols, nRows;
		nCols = moTarget.GetNumCols();
		nRows = moTarget.GetNumRows();
		if ( nCols != phBitmap->Width || nRows != phBitmap->Height )
		{
			ol_delete_bitmap(phBitmap);
			return IMP_ERROR_INCONSISTENT_DIMS;
		}
	}
	///end IGNORE_SUBSEQUENT_FRAMES_IF_INCONSISTENT_RESOLUTION
	if ( TOP_LEFT != phBitmap->ViewPerspective )
	{
		pBITMAPHANDLE phBitmapTemp = ol_new_bitmap();
		if ( phBitmapTemp != NULL )
		{
			if ( SUCCESS == L_CHANGE_VIEW_PERSPECTIVE(phBitmapTemp, phBitmap, TOP_LEFT) )
			{
				ol_delete_bitmap(phBitmap);
				phBitmap = phBitmapTemp;
			}
			else
				ol_delete_bitmap(phBitmapTemp);
		}
	}
	///Sophy 6/21/2010 ORG-339 DISP_16BITS_GRAYSCALE_TIF
	if ( L_IsGrayScaleBitmap(phBitmap) && phBitmap->BitsPerPixel > 8 )
	{
		Image imgTemp;
		imgTemp.SetLBmp(phBitmap, false);
		moTarget.SetInternalDataType(FSI_USHORT, OCD_RESET_VIEW);
		return (imgTemp.CopyTo(moTarget, true, phBitmap->BitsPerPixel, IMAGE_COPY_SCALE) ? IMP_NO_ERROR : IMP_ERROR_COPY_BITMAP_FAIL);
	}
	///end DISP_16BITS_GRAYSCALE_TIF
	if ( !moTarget.SetLeadBitmap(phBitmap, false, true) )
		return IMP_ERROR_SET_BITMAP_FAIL;
	return IMP_NO_ERROR;
}

bool image_import_to_matrix(MatrixLayer& mlTarget, LPCSTR lpcszFile, TreeNode& trFileInfo) //NULL
{
	if ( !mlTarget )
		return false;
	
	FILEINFO fileinfo;
	int nRet = L_FILE_INFO(lpcszFile, &fileinfo, FILEINFO_TOTALPAGES, NULL);
	if( SUCCESS != nRet )
		return false;
	
	HBITMAPLIST hList;
	LOADFILEOPTION stLoadFileOption;
	
	int nOrder = fileinfo.Order;
	if( fileinfo.BitsPerPixel >= 16 && nOrder == ORDER_RGB )
		nOrder = ORDER_BGR;
	nRet = L_LoadBitmapList(lpcszFile, &hList, 0, nOrder, &stLoadFileOption, &fileinfo);
	if ( SUCCESS != nRet )
		return false;
	
	int nBitmapCount;
	nRet = L_GetBitmapListCount(hList, &nBitmapCount);
	if ( SUCCESS != nRet )
		return false;
	
	if ( mlTarget.MatrixObjects.Count() < nBitmapCount )
		mlTarget.SetSize(nBitmapCount); //prepare matrixobjects.
	
	for ( int ii = 0; ii < nBitmapCount; ii++ )
	{
		MatrixObject moTarget(mlTarget, ii);
		int nErr = _image_to_matrix(moTarget, &hList, ii);
		if ( IMP_ERROR_INCONSISTENT_DIMS == nErr )
		{
			///Sophy 6/24/2010 ORG-339-P2 RESET_OBJS_NUMBER_IN_LAYER_WHEN_STOP_IMPORTING
			//mlTarget.Delete(ii);
			mlTarget.SetSize(ii);
			///end RESET_OBJS_NUMBER_IN_LAYER_WHEN_STOP_IMPORTING
			warning_msg_box(_L("Inconsistent frames exist in the same image file, subsequent frames will be ignored."), true, 'W', MB_OK);
			return true;
		}
		else if ( IMP_NO_ERROR != nErr )
			return false;
	}
	
	if ( trFileInfo )
	{
		TreeNode trHeader = tree_check_get_node(trFileInfo, IMPTREE_NODE_HEADER);
		trHeader = fileinfo;
		TreeNode tn = trHeader.GetNode("GlobalPalette");
		tn.Remove();
	}

	return mlTarget.SetViewImage(true);
}

bool image_frame_counts(LPCSTR lpcszFile, int& nBitmaps)
{
	FILEINFO fileinfo;
	int nRet = L_FILE_INFO(lpcszFile, &fileinfo, FILEINFO_TOTALPAGES, NULL);
	if( SUCCESS != nRet )
		return false;
	
	HBITMAPLIST hList;
	LOADFILEOPTION stLoadFileOption;
	
	nRet = L_LoadBitmapList(lpcszFile, &hList, 0, fileinfo.Order, &stLoadFileOption, &fileinfo);
	if ( SUCCESS != nRet )
		return false;
	
	nRet = L_GetBitmapListCount(hList, &nBitmaps);
	if ( SUCCESS != nRet )
		return false;
	return true;
}
///end MULTIFRAME_TIFF_IMPORT

//----- CPY 9/4/06 IMPORT_IMAGE_INTO_WKS_CELL
pBITMAPHANDLE image_import(LPCSTR lpcszFile, FILEINFO* pfi, int* pErrCode)// = NULL =NULL
{
	string strFile = lpcszFile;
	if(!strFile.IsFile())
	{
		if(pErrCode) *pErrCode = IIMP_FILE_NO_FOUND;
		return NULL;
	}
	FILEINFO fi;
	if( SUCCESS != L_FILE_INFO(lpcszFile, &fi, 0, NULL) )
	{
		if(pErrCode) *pErrCode = IIMP_FAILED_GET_FILE_INFO;
		return NULL;
	}	
	pBITMAPHANDLE pLBmp = ol_new_bitmap();
	if( NULL == pLBmp )
	{
		if(pErrCode) *pErrCode = IIMP_CANNOT_CREATE_LBMP;
		return NULL;
	}
	
	//now we are getting the correct file and type and have LeadBitmap initialized	
	if(pfi)
		*pfi = fi;

	/// EJP 2006-11-06 v8.0506 LOAD_RGB_ORDER_AS_BGR_ORDER_FOR_PROPER_DISPLAY
	///	///2006-7-26 Sandy FIX_HISTOGRAM_BUG_ABOUT_JPG, changed from ORDER_BGRORGRAYORROMM to fi.Order
	///	//	int nRet = L_LOADBITMAP(lpcszFile, pLBmp, 0, fi.Order, NULL);
	///	//int nRet = L_LOADBITMAP(lpcszFile, pLBmp, 0, ORDER_BGRORGRAYORROMM, NULL);
	///	int nRet = L_LOADBITMAP(lpcszFile, pLBmp, 0, fi.Order, NULL);
	///	/// end COLOR_IMAGE_SHOW_WRONG_ORDER
	///	/// end FIX_HISTOGRAM_BUG_ABOUT_JPG
	//
	// Order param is used on 16-bit, or higher, color images.  Only TIF was coming in as RGB order and
	// was being displayed incorrectly.  I changed code to load it as BGR order and now display is correct.
	// This problem has come up before and apparently has not been fixed.  I suspect Windows expects BGR
	// order or blue byte in lowest byte of memory.  So, loading RGB images into memory as BGR seems to
	// be the correct fix but this will require more testing.  We may also need to change the BPP check
	// for all color images 16 bits or higher.
	//
	int nOrder = fi.Order;
	/// EJP 2007-09-06 v8.0698 QA70-10350 LOAD_RGB_ORDER_AS_BGR_ORDER_FOR_PROPER_DISPLAY
	///if( fi.BitsPerPixel == 24 && nOrder == ORDER_RGB )
	if( fi.BitsPerPixel >= 16 && nOrder == ORDER_RGB )
	/// end LOAD_RGB_ORDER_AS_BGR_ORDER_FOR_PROPER_DISPLAY
		nOrder = ORDER_BGR;
	int nRet = L_LOADBITMAP(lpcszFile, pLBmp, 0, nOrder, NULL);
	/// end LOAD_RGB_ORDER_AS_BGR_ORDER_FOR_PROPER_DISPLAY
	
	/// end LEAD_BITMAP_GR_OBJ 
	if( SUCCESS == nRet )
	{
		/// EJP 2006-03-10 v8.0374 MAKE_SURE_VIEW_PERSPECTIVE_IS_TOP_LEFT
		if( TOP_LEFT != pLBmp->ViewPerspective )
		{
			pBITMAPHANDLE pLBmpTmp = ol_new_bitmap();
			if( pLBmpTmp )
			{
				if( SUCCESS == L_CHANGE_VIEW_PERSPECTIVE(pLBmpTmp, pLBmp, TOP_LEFT) )
				{
					/// EJP 2009-07-14 QA80-13532 NEED_OL_DELETE_BITMAP_FOR_OL_NEW_BITMAP
					///L_FreeBitmap(pLBmp);
					ol_delete_bitmap(pLBmp);
					/// end NEED_OL_DELETE_BITMAP_FOR_OL_NEW_BITMAP
					pLBmp = pLBmpTmp;
				}
				else
				{
					/// EJP 2009-07-14 QA80-13532 NEED_OL_DELETE_BITMAP_FOR_OL_NEW_BITMAP
					///L_FreeBitmap(pLBmpTmp);
					ol_delete_bitmap(pLBmpTmp);
					/// end NEED_OL_DELETE_BITMAP_FOR_OL_NEW_BITMAP
					if(pErrCode) *pErrCode = IIMP_FAILED_CHANGE_TO_TOP_LEFT;
				}
			}
		}
	}
	return pLBmp;
}
//----- CPY 9/4/06 IMPORT_IMAGE_INTO_WKS_CELL
/*
bool image_import_to_matrix(MatrixObject& moTarget, LPCSTR lpcszFile, int* pErr)
{
	/// EJP 2005-10-31 v8.0326 QA70-8186 LEAD_BITMAP_GR_OBJ 
	///BITMAPHANDLE bh;
	///int nRet = L_LOADBITMAP(lpcszFile, &bh, 0, ORDER_BGR, NULL);
// EJP 2005-11-14 v8.0336 QA70-8247 COLOR_IMAGE_SHOW_WRONG_ORDER
// With the painting code corrected it now seems that loading images
// using BGR order was never a problem.
//	FILEINFO fi;
//	if( SUCCESS != L_FILE_INFO(lpcszFile, &fi, 0, NULL) )
//		return false;
	pBITMAPHANDLE pLBmp = ol_new_bitmap();
	if( NULL == pLBmp )
		return false;
	
	///2006-7-26 Sandy FIX_HISTOGRAM_BUG_ABOUT_JPG
	FILEINFO fi;
	if( SUCCESS != L_FILE_INFO(lpcszFile, &fi, 0, NULL) )
		return false;
	int nRet = L_LOADBITMAP(lpcszFile, pLBmp, 0, fi.Order, NULL);
	

	//	int nRet = L_LOADBITMAP(lpcszFile, pLBmp, 0, fi.Order, NULL);
	//int nRet = L_LOADBITMAP(lpcszFile, pLBmp, 0, ORDER_BGRORGRAYORROMM, NULL);
	/// end COLOR_IMAGE_SHOW_WRONG_ORDER
	/// end FIX_HISTOGRAM_BUG_ABOUT_JPG
	
	/// end LEAD_BITMAP_GR_OBJ 
	if( SUCCESS == nRet )
	{
		/// EJP 2006-03-10 v8.0374 MAKE_SURE_VIEW_PERSPECTIVE_IS_TOP_LEFT
		if( TOP_LEFT != pLBmp->ViewPerspective )
		{
			pBITMAPHANDLE pLBmpTmp = ol_new_bitmap();
			if( pLBmpTmp )
			{
				if( SUCCESS == L_CHANGE_VIEW_PERSPECTIVE(pLBmpTmp, pLBmp, TOP_LEFT) )
				{
					L_FreeBitmap(pLBmp);
					pLBmp = pLBmpTmp;
				}
				else
					L_FreeBitmap(pLBmpTmp);
			}
		}
		/// end MAKE_SURE_VIEW_PERSPECTIVE_IS_TOP_LEFT

		/// EJP 2005-10-31 v8.0326 QA70-8186 LEAD_BITMAP_GR_OBJ 
		///nRet = _ChangeLeadBitmapToMatrixObjectDIB(moTarget, &bh);
		///if( SUCCESS != nRet )
		///	L_FreeBitmap(&bh);
		if( !moTarget.SetLeadBitmap(pLBmp, false, true) ) // false = do not make copy, use what we loaded.
			nRet = FAILURE;
		/// end LEAD_BITMAP_GR_OBJ

		string strNewName = GetFileName(lpcszFile, TRUE);
		if( !strNewName.IsEmpty() )
			moTarget.SetLongName(strNewName);
	}
	if(pErr)
		*pErr = nRet;
	/// EJP 2005-11-07 DRAG_DROP_FALSE_ERR_MESSAGE
	///return false;
	return (SUCCESS == nRet);
	/// end DRAG_DROP_FALSE_ERR_MESSAGE
}
*/
//----- end 



//--------------------------------------------------------------------------
// _ColorSeparateDIB
//
// Create a Red, Green, and Blue DIB from an RGB DIB.
// The RGB DIB is not changed.
//--------------------------------------------------------------------------
static int _ColorSeparateDIB(HDIB hRGB, HDIB& hR, HDIB& hG, HDIB& hB)
{
	BITMAPHANDLE bhRGB;
	int nRet = _CopyDIBToLeadBitmap(&bhRGB, hRGB);
	if( SUCCESS == nRet )
	{
		BITMAPHANDLE bhR, bhG, bhB;
		nRet = ol_color_separate_bitmap(&bhRGB, COLORSEP_RGB, &bhB, &bhG, &bhR);
		if( SUCCESS == nRet )
		{
			hR = L_ChangeToDIB(&bhR);
			hG = L_ChangeToDIB(&bhG);
			hB = L_ChangeToDIB(&bhB);
		}
		L_FreeBitmap(&bhRGB); // no longer need bitmap
	}
	return nRet;
}



//--------------------------------------------------------------------------
// _ChangeLeadBitmapToMatrixObjectDIB
//
// Change a LeadBitmap into a DIB and put the DIB into a MatrixObject.
// The LeadBitmap will be invalid after calling this function.
//--------------------------------------------------------------------------
static int _ChangeLeadBitmapToMatrixObjectDIB(MatrixObject& moTarget, pBITMAPHANDLE pSource, LPCSTR lpcszName = NULL)
{
	if( moTarget && pSource )
	{
		HDIB hSource = L_ChangeToDIB(pSource);
		if( hSource && moTarget.SetDIB(hSource, lpcszName) )
			return SUCCESS;
	}
	return FAILURE;
}

//--------------------------------------------------------------------------
// _CopyMatrixObjectDIBToLeadBitmap
//
// Copy a DIB from a MatrixObject into a LeadBitmap.
// The MatrixObject and DIB are not changed.
//--------------------------------------------------------------------------
static int _CopyMatrixObjectDIBToLeadBitmap(pBITMAPHANDLE pTarget, const MatrixObject& moSource, LPCSTR lpcszName = NULL)
{
	if( pTarget && moSource )
	{
		HDIB hSource = moSource.GetDIB(lpcszName);
		if( hSource )
			return _CopyDIBToLeadBitmap(pTarget, hSource);
	}
	return FAILURE;
}

//--------------------------------------------------------------------------
// _CopyDIBToLeadBitmap
//
// Copy a DIB into a LeadBitmap.
// The DIB is not changed.
//--------------------------------------------------------------------------
static int _CopyDIBToLeadBitmap(pBITMAPHANDLE pTarget, HDIB hSource)
{
	int nColorData;
	BITMAPINFO *pInfo = (BITMAPINFO L_FAR *)GlobalLock(hSource);
	if( pInfo->bmiHeader.biBitCount <= 8 )
		nColorData = 1 << pInfo->bmiHeader.biBitCount;
	else
		nColorData = 0;
	LPBYTE pBits = (L_UCHAR L_FAR *) pInfo + sizeof(BITMAPINFOHEADER) + (nColorData * sizeof(RGBQUAD));

	L_FreeBitmap(pTarget); // be safe, avoid memory leak
	L_INIT_BITMAP(pTarget, 0, 0, pInfo->bmiHeader.biBitCount); // init bitmap as required
	
	return L_CONVERT_FROM_DIB(pTarget, pInfo, pBits);
}
/// end ACCESS_LEADTOOLS_FROM_OC


static int _get_file_ext_group_defaults(string& strOpenPath, string& strSavePath, int& nType, LPCSTR lpcszGroup)
{
	if( NULL == lpcszGroup )
		return -1; // group name is required
	
	using System = LabTalk.System;
	System.FileExt.ActiveGroup$ = lpcszGroup;
	if( 0 != lstrcmpi(lpcszGroup, System.FileExt.ActiveGroup$) )
		return -1; // group not found
	strOpenPath = System.FileExt.DefPath$;
	strSavePath = System.FileExt.SavePath$;
	nType = System.FileExt.DefType;
	return 0;
}

static int _set_file_ext_group_defaults(LPCSTR lpcszOpenPath, LPCSTR lpcszSavePath, int nType, LPCSTR lpcszGroup)
{
	if( NULL == lpcszGroup )
		return -1; // group name is required
	
	using System = LabTalk.System;
	System.FileExt.ActiveGroup$ = lpcszGroup;
	if( 0 != lstrcmpi(lpcszGroup, System.FileExt.ActiveGroup$) )
		return -1; // group not found
	if( lpcszOpenPath )
		System.FileExt.DefPath$ = lpcszOpenPath;
	if( lpcszSavePath )
		System.FileExt.SavePath$ = lpcszSavePath;
	System.FileExt.DefType = nType;
	return 0;
}

/// EJP 2006-11-21 v8.0514 IMPROVE_IMG_EXT_TYPE_UTIL_FUNC
///	static int _get_image_import_file_types(StringArray& saTypes)
///	{
///		saTypes.SetSize(0);
///		/// SY 2006-11-01 v8.0503 ADD_ALL_FILES
///		///	LT_execute("FDlog.UseGroup(Image); Image.GetExtList(z,i); FDlog.UseType(%z);");
///		LT_execute("FDlog.UseGroup(Image); Image.GetExtList(z,im); FDlog.UseType(%z);");
///		/// end ADD_ALL_FILES
static bool get_image_ext_list(string& strExtList, int nCtrl)
{
// Use switch because OC does not support init const string pointer array
//	LPCSTR lpcstrList[] = {"E","EM","I","IM","R","V"};
//	if( nCtrl < 0 || IFT_COUNT <= nCtrl )
//		return -1; // error, invalid 
	string strExtTypes;
	switch( nCtrl )
	{
	case IFT_EXPORT: // graph, layout
		strExtTypes = "E";
		break;
	case IFT_EXPORT_MATRIX:
		strExtTypes = "EM";
		break;
	case IFT_IMPORT: // graph, layout
		strExtTypes = "I";
		break;
	case IFT_IMPORT_MATRIX:
		strExtTypes = "IM";
		break;
	case IFT_RASTER: // all supported raster formats
		strExtTypes = "R";
		break;
	case IFT_VECTOR: // all supported vector formats
		strExtTypes = "V";
		break;
	default:
		return -1;
	}
	string strScript;
//	strScript.Format("Image.GetExtList(z,%s);", lpcstrList[nCtrl]);
	strScript.Format("Image.GetExtList(z,%s);", strExtTypes);
	if( !LT_execute(strScript) )
		return false;
	char szExtList[MAXFULLPATH];
	if( !LT_get_str("%z", szExtList, MAXFULLPATH) )
		return false;
	strExtList = szExtList;
	return true;
}

static int append_image_file_types(StringArray& saTypes, int nCtrl)
{
	string strExtList;
	if( !get_image_ext_list(strExtList, nCtrl) )
		return -1; // error

	string strScript;
	strScript.Format("FDlog.UseGroup(Image); FDlog.UseType(%s);", strExtList);
	LT_execute(strScript);	
/// end IMPROVE_IMG_EXT_TYPE_UTIL_FUNC

	int nTypeCount = LabTalk.FDlog.NumTypes;
	string str;
	char szType[MAXFULLPATH];
	for( int nType = 1; nType <= nTypeCount; nType++ )
	{
		str.Format("FDlog.Type%d$", nType);
		if( LT_get_str(str, szType, MAXFULLPATH) )
			saTypes.Add(szType);
	}
	/// EJP 2006-11-21 v8.0514 IMPROVE_IMG_EXT_TYPE_UTIL_FUNC, should not be done here and should allow translation
	///saTypes.Add("[All Files (*.*)] *.*"); /// SY 2006-11-01 v8.0503 ADD_ALL_FILES
	/// end IMPROVE_IMG_EXT_TYPE_UTIL_FUNC
	return saTypes.GetSize();
}

/// Iris 01/22/2007 v8.0544 REMOVE_TYPES_NOT_SUPPORT_IN_PPT_FROM_LIST
/*
///---Sim 11-30-2006 REMOVE_UNUSUAL_IMAGE_FORMAT
static void remove_unusual_image_types(StringArray& saTypes)
{
	int ii;
	
	ii = saTypes.Find("*.xpm", 0, false, false);
	if ( 0 <= ii )
		saTypes.RemoveAt(ii);
	
	ii = saTypes.Find("*.xwd", 0, false, false);
	if ( 0 <= ii )
		saTypes.RemoveAt(ii);	
}
///---END REMOVE_UNUSUAL_IMAGE_FORMAT
*/
static void remove_unusual_image_types(StringArray& saTypes, int nCtrl = -1)
{
	vector<string> 	vs = {"*.xpm", "*.xwd"};	
	if(IFT_PPT == nCtrl)
	{
		vector<string> vsTrim = {"*.pcx", "*.tga", "*.psd", "*.ai", "*.dxf", "*.pdf"};	
		vs.Append(vsTrim);
	}
	
	for(int ii=0; ii<vs.GetSize(); ii++)
	{
		int nRet = saTypes.Find(vs[ii], 0, false, false);
		if ( 0 <= nRet )
			saTypes.RemoveAt(nRet);		
	}
		
}
///end REMOVE_TYPES_NOT_SUPPORT_IN_PPT_FROM_LIST

/// EJP 2006-11-21 v8.0514 IMPROVE_IMG_EXT_TYPE_UTIL_FUNC
int get_image_file_types(StringArray& saTypes, int nCtrl) // = IFT_RASTER_AND_VECTOR
{
	saTypes.SetSize(0);
	/// Iris 01/22/2007 v8.0544 REMOVE_TYPES_NOT_SUPPORT_IN_PPT_FROM_LIST
	/*
	if( IFT_RASTER_AND_VECTOR == nCtrl )
	{
		if( append_image_file_types(saTypes, IFT_RASTER) < 0 )
			return -1;
		nCtrl = IFT_VECTOR; // fall thru to append vector formats
	}
	///---Sim 11-30-2006 REMOVE_UNUSUAL_IMAGE_FORMAT
	//return append_image_file_types(saTypes, nCtrl);
	if ( append_image_file_types(saTypes, nCtrl) < 0 )
		return -1;
	remove_unusual_image_types(saTypes);
	return saTypes.GetSize();
	///---END REMOVE_UNUSUAL_IMAGE_FORMAT
	*/
	int	nCtrl2 = nCtrl;
	if( IFT_RASTER_AND_VECTOR == nCtrl || IFT_PPT == nCtrl)
	{
		if( append_image_file_types(saTypes, IFT_RASTER) < 0 )
			return -1;
		nCtrl2 = IFT_VECTOR; // fall thru to append vector formats
	}
	if ( append_image_file_types(saTypes, nCtrl2) < 0 )
		return -1;
	remove_unusual_image_types(saTypes, nCtrl);
	return saTypes.GetSize();
	///end REMOVE_TYPES_NOT_SUPPORT_IN_PPT_FROM_LIST
	
}

/// Iris 11/24/06 v8.0515 SUPPORT_MORE_IMAGE_TYPE
/*
/// Iris 11/21/06 TEMP_CODES_TO_ONLY_SUPPORT_PARTIAL_IMAGE_TYPE_FOR_EXPORT
// GUI of new expGraph XF only support 7 image type to export, so just use hard code to get type list temporary!
static int _get_image_file_types_2(StringArray& saTypes, int nCtrl) // = IFT_RASTER_AND_VECTOR
{
	vector<string> 	vsRasterType, vsVectorType;
	vsRasterType.Add("Bitmap (*.bmp)");
	vsRasterType.Add("Graphics Interchange Format (*.gif)");
	vsRasterType.Add("Joint Photographic Experts Group (*.jpg)");
	vsRasterType.Add("Zsoft PC Paintbrush Bitmap (*.pcx)");
	vsRasterType.Add("Tag Image File (*.tif)");
	vsRasterType.Add("Truevision Targa (*.tga)");
	
	vsVectorType.Add("Computer Graphics Metafile(*.cgm)");
	vsVectorType.Add("Auto CAD Drawing InterChange(*.dxf)");
	vsVectorType.Add("Encapsulated Postscript (*.eps)");
	vsVectorType.Add("Enhanced MetaFile (*.emf)");
	vsVectorType.Add("Portable Network Graphics (*.png)");
	vsVectorType.Add("Portable Document Format (*.pdf)");
	vsRasterType.Add("Adobe Photoshop (*.psd)");
	
	saTypes.SetSize(0);
	if(IFT_RASTER == nCtrl || IFT_RASTER_AND_VECTOR == nCtrl)
	{
		saTypes.Append(vsRasterType);
	}
	if(IFT_VECTOR == nCtrl || IFT_RASTER_AND_VECTOR == nCtrl)
	{
		saTypes.Append(vsVectorType);
	}
	return saTypes.GetSize();
}
///end TEMP_CODES_TO_ONLY_SUPPORT_PARTIAL_IMAGE_TYPE_FOR_EXPORT
*/
///end SUPPORT_MORE_IMAGE_TYPE

int get_image_file_type_descrips(StringArray& saTypes, int nCtrl) // = IFT_RASTER_AND_VECTOR
{
	StringArray saFileExtTypes;
	int nRet = get_image_file_types(saFileExtTypes, nCtrl);
	if( nRet < 0 )
		return nRet;

	saTypes.SetSize(0);
	string strDescrip, strExt;
	for( int i = 0; i < saFileExtTypes.GetSize(); i++ )
	{
		if( 0 == _get_file_type_parts(strDescrip, strExt, saFileExtTypes[i]) )
			saTypes.Add(strDescrip);
	}
	return saTypes.GetSize();
}

///---Sim 06-21-2007 GET_EXTENSION_LIST_OF_IMAGE_TYPE
int get_image_file_type_extensions(StringArray& saExts, int nCtrl) // = IFT_RASTER_AND_VECTOR
{
	StringArray saFileExtTypes;
	int nRet = get_image_file_types(saFileExtTypes, nCtrl);
	if( nRet < 0 )
		return nRet;

	saExts.SetSize(0);
	string strDescrip, strExt;
	for( int i = 0; i < saFileExtTypes.GetSize(); i++ )
	{
		if( 0 == _get_file_type_parts(strDescrip, strExt, saFileExtTypes[i], true) )
			saExts.Add(strExt);
	}
	return saExts.GetSize();
}
///---END GET_EXTENSION_LIST_OF_IMAGE_TYPE

bool get_image_file_type_descrip(string& strDescrip, int index, int nCtrl) // = IFT_RASTER_AND_VECTOR
{
	vector<string> vsDescrips;
	if( get_image_file_type_descrips(vsDescrips, nCtrl) < 0 )
		return false;
	if( index < 0 || vsDescrips.GetSize() <= index )
		return false;
	strDescrip = vsDescrips[index];
	return true;
}

bool get_image_file_type_descrip_and_ext(string& strDescrip, string& strExt, int index, int nCtrl) // = IFT_RASTER_AND_VECTOR
{
	if( !get_image_file_type_descrip(strDescrip, index, nCtrl) )
		return false;

	// Following code assumes strType syntax is "Description (*.Ext)"
	int nLastPeriod = strDescrip.ReverseFind('.');
	int nLastPeren = strDescrip.ReverseFind(')');
	if( nLastPeriod < 0 || nLastPeren <= nLastPeriod )
		return false;
	
	strExt = strDescrip.Mid(nLastPeriod + 1, nLastPeren - nLastPeriod - 1);
	return true;
}

bool is_image_file_type_ext(LPCSTR lpcszExt, int nCtrl)
{
	if( NULL == lpcszExt || 0 == *lpcszExt )
		return false; // error
	string strExtList;
	if( !get_image_ext_list(strExtList, nCtrl) )
		return false; // error
	vector<string> vsExtList;
	/// Hong 10/31/07 v8.0737 FILE_EXTENSION_IS_SENSELESS
	//strExtList.GetTokens(vsExtList, ' ');	
	//if( vsExtList.Find(lpcszExt) < 0 )
	strExtList.MakeUpper();
	strExtList.GetTokens(vsExtList, ' ');
	
	string strExt(lpcszExt);
	strExt.MakeUpper();
	if( vsExtList.Find(strExt) < 0 )
	/// end FILE_EXTENSION_IS_SENSELESS
		return false; // ext not found
	return true; // ext found
}
/// end IMPROVE_IMG_EXT_TYPE_UTIL_FUNC

// If lpcszType == "[All Files (*.*)] *.*" then
// strDescrip = "All Files (*.*)"
// strExt = "*.*"
///---Sim 06-21-2007 GET_EXTENSION_LIST_OF_IMAGE_TYPE
//static int _get_file_type_parts(string& strDescrip, string& strExt, LPCSTR lpcszType)
static int _get_file_type_parts(string& strDescrip, string& strExt, LPCSTR lpcszType, bool bRemoveExtPeriod = false)
///---END GET_EXTENSION_LIST_OF_IMAGE_TYPE
{
	if( NULL == lpcszType )
		return -1; // file type string is required

	string strType = lpcszType;
	strType.TrimLeft();
	if( strType[0] != '[' )
		return -1; // string is not labtalk file type
	strType.Delete(0); // delete '['

	int n = strType.ReverseFind(']');
	if( n < 0 )
		return -1; // string is not labtalk file type

	strDescrip = strType.Left(n); // copy everything before the last ']'
	strDescrip.TrimRight();
	
	strExt = strType.Mid(n + 1); // copy everything after the last ']'
	strExt.TrimLeft();
	strExt.TrimRight();
	
	///---Sim 06-21-2007 GET_EXTENSION_LIST_OF_IMAGE_TYPE
	if ( bRemoveExtPeriod )
	{
		int nLastPeriod = strExt.ReverseFind('.');
		if( nLastPeriod >= 0 )
			strExt.Delete(0, nLastPeriod + 1);
	}
	///---END GET_EXTENSION_LIST_OF_IMAGE_TYPE
			
	return 0;
}

///---Sim 08-22-2007 MAKE_IMAGE_TYPE_LIST_SORTED_BY_EXT
int get_image_file_type_descrips_sorted_by_extension(StringArray& saTypes, int nCtrl) // = IFT_RASTER_AND_VECTOR
{
	StringArray saDesc, saExt;
	
	get_image_file_type_descrips(saDesc, nCtrl);
	get_image_file_type_extensions(saExt, nCtrl);
	
	saTypes.SetSize(saDesc.GetSize());
	
	// sorting
	vector<uint> vSort;
	saExt.Sort(SORT_ASCENDING, true, vSort);
	for( int i = 0; i < saTypes.GetSize(); i++ )
	{
		saTypes[i] = saDesc[vSort[i]];
	}
	
	return saTypes.GetSize();
}
int get_image_file_type_extensions_sorted(StringArray& saExts, int nCtrl) // = IFT_RASTER_AND_VECTOR
{
	get_image_file_type_extensions(saExts, nCtrl);
	
	saExts.Sort();
	
	return saExts.GetSize();
}
///---END MAKE_IMAGE_TYPE_LIST_SORTED_BY_EXT

#define FILE_DIALOG_MAX_FILTER_LEN 2048
//------CPY 10/5/05, moved from ocImgLT.h, const used only locally, no need to put into shared header
#if LEADTOOLS_VER == 14
#define SUCCESS_DLG_OK                   100 /** The "OK" button was pressed, and the dialog exited successfully **/
#else // !LEADTOOLS_VER == 14
#define SUCCESS_DLG_OK					SUCCESS
#endif // !LEADTOOLS_VER == 14

bool image_file_dlg(HWND hwndParent, string& szFileName, LPCSTR lpcszTitle, bool bOpen) // = NULL, true
{
	StringArray saFileName;
	if( !image_files_dlg(hwndParent, saFileName, lpcszTitle, bOpen) )
		return false;
	szFileName = saFileName[0];
	return true;
}

bool image_files_dlg(HWND hwndParent, StringArray& saFileName, LPCSTR lpcszTitle, bool bOpen, bool bMultiSel) // = NULL, true, false
{
	StringArray saTypes;
	/// EJP 2006-11-21 v8.0514 IMPROVE_IMG_EXT_TYPE_UTIL_FUNC
	///	int nTypeCount = _get_image_import_file_types(saTypes);
	int nTypeCount = get_image_file_types(saTypes, IFT_IMPORT_MATRIX);
	/// end IMPROVE_IMG_EXT_TYPE_UTIL_FUNC

	/// EJP 2007-02-01 v8.0553 QA70-9329 FILE_EXT_GRP_ALL_TYPES
	string strAllTypes;
	if( get_file_group_alltypes(strAllTypes, saTypes, _L("Images")) )
	{
		saTypes.Add(strAllTypes);
		nTypeCount++;
	}
	/// end FILE_EXT_GRP_ALL_TYPES

	char szFilter[FILE_DIALOG_MAX_FILTER_LEN];

	// Convert all the file type strings into a single filter string for the file dialog
	// This code may be useful as a separate utility function for use by others.
	char *pc = szFilter;
	string strDescrip, strExt;
	for( int nType = 0; nType < nTypeCount; nType++ )
	{
		if( 0 == _get_file_type_parts(strDescrip, strExt, saTypes[nType]) )
		{
			lstrcpy(pc, strDescrip);
			pc += strDescrip.GetLength() + 1;
			lstrcpy(pc, strExt);
			pc += strExt.GetLength() + 1;
		}
	}
	*pc = 0; // double null terminate filter string

	string strOpenPath, strSavePath;
	int nDefType;
	_get_file_ext_group_defaults(strOpenPath, strSavePath, nDefType, "Image");
	
	LPCSTR lpcszPath;
	if( bOpen )
		lpcszPath = strOpenPath;
	else
		lpcszPath = strSavePath;
	
	///char szFile[MAX_PATH];
	#define MULTI_FILE_NAME_BUF_SIZE (MAX_PATH * 100 )
	char szFile[MULTI_FILE_NAME_BUF_SIZE];

	int nRet = ol_dlg_file_open(hwndParent, szFile, MULTI_FILE_NAME_BUF_SIZE, szFilter, lpcszPath, &nDefType, lpcszTitle, bMultiSel);
	if( SUCCESS_DLG_OK == nRet )
	{
		LPCSTR pFileName = szFile;
		while( *pFileName )
		{
			saFileName.Add(pFileName);
			pFileName += lstrlen(pFileName) + 1;
		}

		/// EJP 2007-07-02 v8.0653 QA70-9939 SAVEAS_PATH_NEED_UPDATE_OPEN_PATH
		///	if( bOpen )
		///		strOpenPath = GetFilePath(szFile);
		///	else
		///		strSavePath = GetFilePath(szFile);
		///	_set_file_ext_group_defaults(strOpenPath, NULL, nDefType, "Image");
		if( bOpen )
		{
			strOpenPath = GetFilePath(szFile);
			_set_file_ext_group_defaults(strOpenPath, NULL, nDefType, "Image");
		}
		else // must be Save As dialog
		{
			strSavePath = GetFilePath(szFile);
			_set_file_ext_group_defaults(NULL, strSavePath, nDefType, "Image");
		}
		/// end SAVEAS_PATH_NEED_UPDATE_OPEN_PATH

		return true;
	}
	return false;
}


//---- CPY 5/10/06 USE_MAT_CACHE_FOR_PROFILE
static bool _get_page_modified_time(const string& strBook, double& dModified) // this should go into page_utils
{
	Page pg(strBook);
	if(pg)
	{
		PageSystemInfo	PgInfo;
		if(pg.GetPageSystemInfo(&PgInfo))
		{
			dModified = PgInfo.dModified;
			return true;
		}
	}
	error_report("failed to get page modified time");
	return false;
}

static bool _is_new_mat(const string& strDataset, const string& strBook)
{
	static string s_strDatasetCache;
	static double s_dModified = 0;
	double dModified;
	if(!_get_page_modified_time(strBook, dModified))
		return true;
	
	if(strDataset == s_strDatasetCache && dModified <= s_dModified )
		return false;
	s_dModified = dModified;
	s_strDatasetCache = strDataset;
	return true;
}
//----end USE_MAT_CACHE_FOR_PROFILE
//---- CPY 2/23/2007 MAT_PROFILE_SHOWS_WRONG_VALUES_DUE_TO_WRONG_XY
static void _linear_transform(vector& v, double vMin, double vMax, double min, double max)
{
	for(int ii = 0; ii < v.GetSize(); ii++)
		v[ii] = min + (max - min) * (v[ii]-vMin)/(vMax-vMin);
}
/// EJP 2006-05-10 v8.0387 QA70-8187 GET_DATA_VALUES_DIRECT_FROM_IMAGE
int profiler(bool bHorz, string src, double x1, double y1, double x2, double y2, string dst, int nIndep, int z)
{
	//---- CPY 5/10/06 USE_MAT_CACHE_FOR_PROFILE
	/*
	string pgName, mlName, objName;
	if( !okutil_parse_complete_range_string(src, &pgName, &mlName, &objName) )
		return -1;

	MatrixPage pg(pgName);
	if( !pg )
		return -1;
	MatrixLayer ml = pg.Layers(mlName);
	if( !ml )
		return -1;
	MatrixObject mo = ml.MatrixObjects();
	if( !mo )
		return -1;
	// Copy source data to local matrix
	matrixbase& matTmp = mo.GetDataObject();
	matrix<double> mat = matTmp;
	*/
	static matrix s_mat;
	string strDataset, strBook;
	if(!okoc_find_dataset(src, &strDataset, &strBook, DATASET_MATRIX))
		return -1;
	
	MatrixObject mo(strDataset);
	if(!mo)
		return -1;
	if(_is_new_mat(strDataset, strBook))
	{
		matrixbase& matTmp = mo.GetDataObject();
		s_mat = matTmp;
	}
	//---- end USE_MAT_CACHE_FOR_PROFILE

	// Init polyline path
	vector vx, vy;
	//---- CPY 2/23/2007 MAT_PROFILE_SHOWS_WRONG_VALUES_DUE_TO_WRONG_XY
	double xmin,ymin,xmax,ymax;
	int nRows = mo.GetNumRows(), nCols = mo.GetNumCols();
	mo.GetXY(xmin,ymin,xmax,ymax);
	vx.Add(x1);
	vx.Add(x2);
	vy.Add(y1);
	vy.Add(y2);
	_linear_transform(vx, xmin, xmax, 0, nCols-1);
	_linear_transform(vy, ymin, ymax, 0, nRows-1);
	//----
	
	// Init polyline size
	int nSize;
	if( bHorz )
		nSize = s_mat.GetNumCols();
	else
		nSize = s_mat.GetNumRows();

	// Init vectors to receive profile data
	vector vxOut, vyOut, vzOut, vErr;
	vxOut.SetSize(nSize);
	vyOut.SetSize(nSize);
	vzOut.SetSize(nSize);
	vErr.SetSize(nSize);

	// Get profile data
	int nRet = ocmath_image_lines_profile(
		s_mat.GetNumRows(), s_mat.GetNumCols(), s_mat,
		2, vx, vy,
		nSize, vxOut, vyOut, vzOut, vErr,
		1, INTERP2_NEAREST, PROJECTION_NONE);

	// Create dataset for accessing profile worksheet
	Dataset ds;
	
	// Attach dataset to X column of profile worksheet 
	if( !ds.Attach(dst, nIndep) )
		return -1;
	
	// Put X data into profile worksheet
	if( bHorz )
	{
		//---- CPY 2/23/2007 MAT_PROFILE_SHOWS_WRONG_VALUES_DUE_TO_WRONG_XY
		ASSERT(vxOut.GetSize() == nCols);
		_linear_transform(vxOut, 0, nCols-1, xmin, xmax);
		//----
		ds = vxOut;
	}
	else
	{
		//---- CPY 2/23/2007 MAT_PROFILE_SHOWS_WRONG_VALUES_DUE_TO_WRONG_XY
		ASSERT(vyOut.GetSize() == nRows);
		_linear_transform(vyOut, 0, nRows-1, ymin, ymax);
		//----
		ds = vyOut;
	}

	// Attach dataset to Y column of profile worksheet 
	if( !ds.Attach(dst, z) )
		return -1;
	
	// Put Y data into porfile worksheet
	ds = vzOut;
		
	return 0;
}
/// end GET_DATA_VALUES_DIRECT_FROM_IMAGE


///Sandy 2006-8-14 MOVE_FROM_75_PALEDIT_OPJ
// Function: ReadColorMapBinary
// This function reads the color map from a binary palette file - the format for the
// binary file is same as the Microsoft Palette file
int read_color_map_binary(string strPalfile, short& nColors, vector<byte>& vR, vector<byte>& vG, vector<byte>& vB)
{
	
	bool bRet;
	int ierr;

	file ff;
	bRet = ff.Open(strPalfile, file::modeRead);
	if(!bRet) return CER_PAL_FILE_OPERATION_FAILED;
	
	// first read header information that includes some text 
	// plus information on file size etc.

	int ijunk;
	ierr = ff.Read(&ijunk,4);	// read and discard "RIFF"
	int isize;
	ierr = ff.Read(&isize,4);	// read file size
	ierr = ff.Read(&ijunk,4);	// read and discard "PAL "
	ierr = ff.Read(&ijunk,4);	// read and discard "data"

	ierr = ff.Read(&isize,4);	// read size
	short nShort;
	ierr = ff.Read(&nShort,2);	// read short

	ierr = ff.Read(&nColors,2);	// read num colors
	
	if (nColors < 2 | nColors > 256)
	{
		bRet = ff.Close();
		return CER_TOO_MANY_OR_TOO_LITTLE_COLORS_IN_PAL_FILE;
	}	

	vR.SetSize(nColors);
	vG.SetSize(nColors);
	vB.SetSize(nColors);
	// now read icol entries of the color map
	for (int ii=0; ii < nColors; ii++)
	{	
		int ivalue;
		ierr = ff.Read(&ivalue,4);	
		vB[ii] = (byte) (ivalue / (256 * 256));
		ivalue = ivalue - vB[ii] * 256 * 256;
		vG[ii] = (byte) (ivalue / 256);
		vR[ii] = (byte) (ivalue - vG[ii] * 256);		

	}

	// close file
	bRet = ff.Close();
	if(!bRet) return CER_PAL_FILE_OPERATION_FAILED;
	
	return OE_NOERROR;
} 



// export an image using current ini settings or prompt user with export options
bool export_image(Image &image, LPCSTR lpcszFileName, LPCSTR lpcszFormat, BOOL bShowOptions)
{

	if(!image.IsValid())
		return false;
	string str;
	str.Format("Image.ShowOptions=%d;Image.FileName$=%s;", bShowOptions, lpcszFileName);
	LT_execute(str);

	str.Format(EPTI_LT_VAR"=Image.Export.PageDPI(%s);", lpcszFormat);

	if( !LT_execute(str) )
		return false;

	return true;
}

// export an image using the specified settings
bool export_image(LPCSTR lpcszFileName, LPCSTR lpcszFormat, Image &image, int nWidth, int nHeight, int nBitsPerPixel, int nCompression)
{
	if(!image.IsValid())
		return false;
	
	string str;
	str.Format("Image.ShowOptions=0;Image.FileName$=%s;", lpcszFileName);
	if( !LT_execute(str) )
		return false;
	
	
	if( 0 == nHeight ) // height not specified, use width as DPI
		str.Format(EPTI_LT_VAR"=Image.Export.PageDPI(%s, %d, %d, %d);", lpcszFormat, nWidth, nBitsPerPixel, nCompression);	
	else
		str.Format(EPTI_LT_VAR"=Image.Export.PagePixel(%s, %d, %d, %d, %d);", lpcszFormat, nWidth, nHeight, nBitsPerPixel, nCompression);	

	return LT_execute(str) ? true : false;
}

/// EJP 2006-11-20 v8.0514 FIX_EXPORT_MATRIX_RET_VAL
///bool export_Matrix_to_image(LPCSTR lpcszFileName, LPCSTR lpcszFormat, MatrixObject &mo)
///---Sim 01-03-2007 FIX_GRAY_SCALE_FAIL_TO_WORK
//int export_Matrix_to_image(LPCSTR lpcszFileName, LPCSTR lpcszFormat, MatrixObject &mo)
int export_Matrix_to_image(LPCSTR lpcszFileName, LPCSTR lpcszFormat, MatrixObject &mo, int nDPI, bool bGray) // = 96, false
///---END FIX_GRAY_SCALE_FAIL_TO_WORK
/// end FIX_EXPORT_MATRIX_RET_VAL
{
	if(!mo.IsValid())
		return -1;
	
	string str;
	str.Format("Image.ShowOptions=0;Image.FileName$=%s;", lpcszFileName);
	if( !LT_execute(str) )
		return -1;
	
	/// EJP 2006-11-17 v8.0513 MAT_EXPORT_IMAGE_NEED_RANGE_STR_TO_INDICATE_WHICH_MATRIX	
	///str.Format(EPTI_LT_VAR"=Image.Export.Matrix(%s, %s);", mo.GetName(), lpcszFormat);
	string strName;
	if( !mo.GetRangeString(strName) )
		return -1;
	///---Sim 01-03-2007 FIX_GRAY_SCALE_FAIL_TO_WORK
	//str.Format(EPTI_LT_VAR"=Image.Export.Matrix(%s, %s);", strName, lpcszFormat);
	str.Format(EPTI_LT_VAR"=Image.Export.Matrix(%s, %s, %d, %d);", strName, lpcszFormat, nDPI, bGray?1:0);
	///---END FIX_GRAY_SCALE_FAIL_TO_WORK
	/// end MAT_EXPORT_IMAGE_NEED_RANGE_STR_TO_INDICATE_WHICH_MATRIX

	/// EJP 2006-11-20 v8.0514 FIX_EXPORT_MATRIX_RET_VAL
	///return LT_execute(str) ? true : false;
	// LabTalk's Image.Export.Matrix method returns 0 for success or >0 for error.
	// export_Matrix_to_image will return <0 to indicate non-Image.Export.Matrix error.
	int nImgExpErr = -1; // LabTalk error
	if( LT_execute(str) )
	{
		double dImgExpErr;
		if( LT_get_var(EPTI_LT_VAR, &dImgExpErr) )
			nImgExpErr = (int)dImgExpErr;
	}
	return nImgExpErr;
	/// end FIX_EXPORT_MATRIX_RET_VAL
}

#ifdef JUNK
/// Iris 11/17/06 MOVE_EXPORT_PAGE_CODE_AS_GLOBAL_FROM_XF
///---Sim 11-17-2006 MORE_MOVING_FOR_EXPORT
//------- Iris 11/21/06 WANT_NOT_SUPPORT_VECTOR_TYPE_IN_EXP_IMAGE
//string export_get_type_list(int nType, vector<string>* pvsTypes)// = -1, NULL
string export_get_type_list(int nType, vector<string>* pvsTypes, bool bIncVecType)// = -1, NULL, true
//-------
{
	vector<string> vsTypes;
	//----- Iris 8/25/06 only support 6 image type to export temporary
	//if( !get_export_image_types(vsTypes) )
	//	return;
	vsTypes.Add("Bitmap (*.bmp)");
	vsTypes.Add("Encapsulated Postscript (*.eps)");
	vsTypes.Add("Joint Photographic Experts Group (*.jpg)");
	vsTypes.Add("Tag Image File (*.tif)");
	vsTypes.Add("Enhanced MetaFile (*.emf)");
	vsTypes.Add("Portable Document Format (*.pdf)");
	//-----	
	
	if(!bIncVecType)
	{
		///---Sim 11-21-2006 FIX_BUG_FOR_NOT_VECTOR_IMAGE_TYPE
		//for(int ii=vsTypes.GetSize()-1; ii>=0; ii++)
		for(int ii=vsTypes.GetSize()-1; ii>=0; ii--)
		///---END FIX_BUG_FOR_NOT_VECTOR_IMAGE_TYPE
		{
			string  strExt = export_get_ext_from_file_type(vsTypes[ii]);
			if( IMAGE_TYPE_VEC == export_check_image_type(strExt) )
				vsTypes.RemoveAt(ii);
		}
	}
	
	if(NULL != pvsTypes)
	{
		*pvsTypes = vsTypes;
	}
	
	string strType;
	//------- Iris 11/21/06 WANT_NOT_SUPPORT_VECTOR_TYPE_IN_EXP_IMAGE
	//if(nType>=0)
	if( nType>=0 && nType<vsTypes.GetSize() )
	//-------
		strType = vsTypes[nType];
	return strType;
}

string export_get_ext_from_file_type(LPCSTR lpcszType, bool bMakeUpper)// = false
{
	string 	strType(lpcszType);	
	if( is_numeric(strType) )
		strType = export_get_type_list(atoi(strType));
	
	string  strExt = strType.GetToken(strType.GetNumTokens(' ')-1, ' ');	
	strExt.TrimLeft("(*.");
	strExt.TrimRight(')');
	
	
	if(bMakeUpper)
		strExt.MakeUpper();
		
	return strExt;
}

#endif // JUNK

bool export_check_path_show_warnning(string& strPath)
{
	while(strPath.IsFile())//check the file exist or not
	{
		string 	strErr;
		strErr.Format("%s already exists.\nDo you want to replace it?", strPath);
		if(IDNO == MessageBox(NULL, strErr, "Attention!", MB_YESNO))	
		{
			string strName = InputBox("Please enter a new name");
			if(strName.IsEmpty())
				return false;
			string 	strExt = GetFileName(strPath, false);
			strExt = strExt.GetToken(1, '.');
			strPath = GetFilePath(strPath) + strName + "." + strExt;
		}	
		else
			return true;
	}
	return true;
}

int	export_check_image_type(LPCSTR lpcszType)
{
	string 	strType(lpcszType);
	if(strType.IsEmpty())
		return IMAGE_TYPE_INVALID;
	
	vector<string> 		vsDot = {"JPG", "DIB", "BMP", "TIF","GIF", "PCX", "TGA", "XPM", "XWD"};
	if( vsDot.Find(strType, 0, false) >= 0)
		return IMAGE_TYPE_DOT;
	
	vector<string> 		vsVector = {"EMF", "WMF", "EPS", "AI", "DXF", "PNG", "PDF", "PSD", "TIF", "CGM"};
	if( vsVector.Find(strType, 0, false) >= 0)
		return IMAGE_TYPE_VEC;
	
	return IMAGE_TYPE_INVALID;	
}

void export_gui_show_options_branch(TreeNode& trImageOptions, LPCSTR lpcszExt)
{	
	//hide all branch except the specified type	
	tree_set_attribute_to_all_nodes(trImageOptions, STR_SHOW_ATTRIB, "0", true, false);
	
	TreeNode trSelType = trImageOptions.FindNodeByAttribute(STR_ATTRIB_IMAGE_TYPE, lpcszExt, false);
	if(trSelType)
	{
		trImageOptions.Show = 1;
		trSelType.Show = 1;
	}
	else//not image options for EMF
	{
		trImageOptions.Show = 0;
	}
	if ( trImageOptions.NoteInfo ) ///---Sim 11-28-2006 IMAGE_FILE_SIZE_NOT_CHANGE_BY_DPI
	{
		bool 	bShow = IMAGE_TYPE_DOT == export_check_image_type(lpcszExt)? true : false;
		/// Iris 01/24/2007 v8.0547 SUPPORT_DPI_FOR_GIF_TGA_TYPE
		//if(0 == lstrcmpi(lpcszExt, "GIF") || 0 == lstrcmpi(lpcszExt, "TGA"))
		//	bShow = false;
		///end SUPPORT_DPI_FOR_GIF_TGA_TYPE
		trImageOptions.NoteInfo.Show  = bShow;		
	}
}
///---END MORE_MOVING_FOR_EXPORT

bool export_gui_construct_options_branch(TreeNode& trOptions)
{
	if(!trOptions.IsValid())
		return false;
	
	SHOW_TIME(NULL);//---- CPY 4/23/07 GRAPH_EXPORT_SPEED_TESTING

	GETN_USE(trOptions)
	GETN_STR(NoteInfo,"",_L("Note: Large DPI setting can lead to very large disk file")) GETN_INFO
	///Arvin 04/13/07 v8.0600 IMPROVE_SPEED_FOR_EXPORT_GRAPH
	/*
	_gui_update_export_options_for_eps(trOptions); // EPS	
	_gui_update_export_options_for_jpg(trOptions); // JPG	
	_gui_update_export_options_for_tif(trOptions); // TIF	
	_gui_update_export_options_for_bmp(trOptions); // BMP	
	_gui_update_export_options_for_pdf(trOptions); // PDF
	/// EJP 2006-11-21 v8.0514 IMPROVE_IMG_EXT_TYPE_UTIL_FUNC	
	_gui_update_export_options_for_gif(trOptions); // GIF
	/// end IMPROVE_IMG_EXT_TYPE_UTIL_FUNC
	/// Iris 11/24/06 v8.0515 SUPPORT_MORE_IMAGE_TYPE
	_gui_update_export_options_for_cgm(trOptions);
	_gui_update_export_options_for_dxf(trOptions);
	_gui_update_export_options_for_pcx(trOptions);
	_gui_update_export_options_for_png(trOptions);
	_gui_update_export_options_for_tga(trOptions);
	_gui_update_export_options_for_psd(trOptions);
	///---Sim 11-30-2006 REMOVE_UNUSUAL_IMAGE_FORMAT
	//_gui_update_export_options_for_xpm(trOptions);
	//_gui_update_export_options_for_xwd(trOptions);
	///---END REMOVE_UNUSUAL_IMAGE_FORMAT
	_gui_update_export_options_for_wmf(trOptions);
	_gui_update_export_options_for_ai(trOptions);
	*/
	gui_update_export_options_for_eps(trOptions); // EPS	
	gui_update_export_options_for_jpg(trOptions); // JPG	
	gui_update_export_options_for_tif(trOptions); // TIF	
	gui_update_export_options_for_bmp(trOptions); // BMP	
	gui_update_export_options_for_pdf(trOptions); // PDF
	gui_update_export_options_for_gif(trOptions); // GIF
	gui_update_export_options_for_cgm(trOptions);
	gui_update_export_options_for_dxf(trOptions);
	gui_update_export_options_for_pcx(trOptions);
	gui_update_export_options_for_png(trOptions);
	gui_update_export_options_for_tga(trOptions);
	gui_update_export_options_for_psd(trOptions);	
	gui_update_export_options_for_wmf(trOptions);
	gui_update_export_options_for_ai(trOptions);
	///end IMPROVE_SPEED_FOR_EXPORT_GRAPH
	//end SUPPORT_MORE_IMAGE_TYPE
		
	SHOW_TIME("after construct, before loop");//---- CPY 4/23/07 GRAPH_EXPORT_SPEED_TESTING

	foreach(TreeNode trNode in trOptions.Children )
	{
		string strType;
		if(!trNode.GetAttribute(STR_ATTRIB_IMAGE_TYPE, strType)) // skip the tree node that not image type branch, like page settings
			continue;
		
		trNode.Show = false;
		///---Sim 06-29-2007 THEME_MECHANISM_INSTEAD_OF_INI_SETTING
		/*
		// init the values of GetN node from ini settings
		Tree trSettings;
		tree_read_image_export_settings(trSettings, strType); //read image export settings from ini file		
		tree_copy_ids_by_tagname(trNode, trSettings); //copy ids from GetN tree to INI settings tree		
		tree_copy_values_by_id(trSettings, trNode); //copy values from INI settings tree to GetN tree to do initialization
		*/
		///---END THEME_MECHANISM_INSTEAD_OF_INI_SETTING

		/// EJP 2006-10-04 v8.0493 USE_CORRECT_KEY_NAMES_USED_BY_OIMG
		if( 0 == strType.CompareNoCase("TIF") )
		{
			convert_node_value_from_index_to_str(trNode.ColorSpace, "Combo");
			convert_node_value_from_index_to_str(trNode.Compression, "Combo");
		}
		/// end USE_CORRECT_KEY_NAMES_USED_BY_OIMG
		convert_color_depth_from_num_to_str(trNode.BitsPerPixel);
	}
	SHOW_TIME("after loop");//---- CPY 4/23/07 GRAPH_EXPORT_SPEED_TESTING
	
	return true;	
}

///---Sim 07-04-2007 FIX_IMAGE_SETTING_TREE_NODE_EVENT
//static bool _gui_export_options_eps_event(TreeNode& trGetN, int nRow, int nCntrlType, Dialog& getNDlg)
static bool _gui_export_options_eps_event(TreeNode& tr, int nRow, int nCol, TreeNode& trNode, DWORD nEventInfo, int nCntrlType, WndContainer& getNContainer)
///---END FIX_IMAGE_SETTING_TREE_NODE_EVENT
{
	///Sophy 7/16/2010 ORG-580 ADD_EPS_OPTION_TO_SUPPORT_EXPORT_GRAPH_WITH_RASTER_EMBEDDING
	string strTagName = trNode.tagName;
	if ( strTagName.CompareNoCase("Preview") == 0 )
	{
	///end ADD_EPS_OPTION_TO_SUPPORT_EXPORT_GRAPH_WITH_RASTER_EMBEDDING
		///---Sim 07-04-2007 FIX_IMAGE_SETTING_TREE_NODE_EVENT
		//TreeNode trPreview = tree_get_node(trGetN, nRow);	
		TreeNode trPreview = trNode;	
		///---END FIX_IMAGE_SETTING_TREE_NODE_EVENT
		TreeNode trPreviewBranch = trPreview.Parent();
		if(!trPreview || !trPreviewBranch)
			return false;
		
		///---Sim 07-04-2007 FIX_IMAGE_SETTING_TREE_NODE_EVENT
		//bool	bShowOthers = 0 == trPreview.strVal.CompareNoCase("TIFF")? true : false;
		//trPreviewBranch.Resolution.Show = bShowOthers;
		//trPreviewBranch.Compression.Show = bShowOthers;
		bool	bEnableOthers = 0 == trPreview.strVal.CompareNoCase("TIFF")? true : false;
		trPreviewBranch.Resolution.Enable = bEnableOthers;
		trPreviewBranch.Compression.Enable = bEnableOthers;
		///---END FIX_IMAGE_SETTING_TREE_NODE_EVENT
	///Sophy 7/16/2010 ORG-580 ADD_EPS_OPTION_TO_SUPPORT_EXPORT_GRAPH_WITH_RASTER_EMBEDDING
	}
	else if ( strTagName.CompareNoCase("SemiTransOpt") == 0 )
	{
		int nRadioIndex = trNode.nVal;
		TreeNode trRaster = trNode.Parent();
		trRaster.DestRastOperRes.Show = (SEMITRANS_DRAW_RASTER_CUSTOMIZED_RES == nRadioIndex); //only when select the customized resolution will show this option		
	}
	else
		ASSERT(false);
	///end ADD_EPS_OPTION_TO_SUPPORT_EXPORT_GRAPH_WITH_RASTER_EMBEDDING
	return true;	
}

///Arvin 04/13/07 v8.0600 IMPROVE_SPEED_FOR_EXPORT_GRAPH
//static void	_gui_update_export_options_for_eps(TreeNode& tr)
void	gui_update_export_options_for_eps(TreeNode& tr)
///end IMPROVE_SPEED_FOR_EXPORT_GRAPH
{
	if(!tr.IsValid())
		return;
	
	GETN_USE(tr)
	GETN_BEGIN_BRANCH(EPS, _L("EPS Options"))	GETN_ID_BRANCH(DLG_EPS_OPTIONS) GETN_OPTION_BRANCH(GETNBRANCH_OPEN)
	
		GETN_BEGIN_BRANCH(PostScript, _L("Post Script"))	GETN_ID_BRANCH(IMG_EPS_POSTSCRIPT_BRANCH)
			GETN_COMBO(PSLevel, _L("PostScript Level"), 2, "1|2|3")	GETN_ID(IMG_EPS_PSLEVEL)
			/// Iris 07/12/2007 v8.0658 NO_LABEL_FOR_RADIO_BUTTON
			//GETN_RADIO_INDEX(Format, 0, "ASCII|Binary")	GETN_ID(IMG_EPS_FORMAT)
			GETN_LIST(Format, _L("Data Format"), 0, _L("ASCII|Binary"))	GETN_ID(IMG_EPS_FORMAT)
			///end NO_LABEL_FOR_RADIO_BUTTON
			//GETN_STRLIST(Colors, _L("Color Format"), "RGB", "RGB|CMYK")	GETN_ID(IMG_EPS_COLORS)
			GETN_STRLIST_L(Colors, _L("Color Format"), "RGB", "RGB|CMYK")	GETN_ID(IMG_EPS_COLORS) /// Hong 10/25/07 QA80-10577 MORE_COMBO_STR_STAY_AS_E_INTERNALLY_IN_DYNA_CNTRL
			GETN_LIST(DestRastOper, _L("Handling"), 2, _L("Ignore|Source Copy|Individual Bitmaps|Combine All Bitmaps"))	GETN_ID(IMG_EPS_DESTRASTOPER)
			GETN_COMBO(DestRastOperRes, _L("Resolution"), 150, "72|96|100|150|300|600|1200")	GETN_ID(IMG_EPS_DESTRASTOPERRES)
		GETN_END_BRANCH(PostScript)	
		
		///---Sim 08-09-2007 MAKE_EPS_INI_SETING_SAME_AS_75
		//GETN_BEGIN_BRANCH(PreviewType, "Preview")	GETN_ID_BRANCH(IMG_EPS_PREVIEW_BRANCH)
		//As there are same tagname "Preview" on tree setting, can't load setting from eps ini file.
		//But the luck is export design is changed, now no need to load ini file since xf has theme.
		GETN_BEGIN_BRANCH(Preview, _L("Preview"))	GETN_ID_BRANCH(IMG_EPS_PREVIEW_BRANCH)
		///---END MAKE_EPS_INI_SETING_SAME_AS_75

			/// EJP 2007-08-09 v8.0679 USE_CORRECT_KEY_NAMES_USED_BY_OIMG
			///	/// EJP 2006-10-03 v8.0493 USE_CORRECT_KEY_NAMES_USED_BY_OIMG
			///	///GETN_STRLIST(PreviewType, "Type", "TIFF", "None|TIFF|Windows Meta File")	GETN_ID(IMG_EPS_PREVIEW)  GETN_OPTION_EVENT(_gui_export_options_eps_event)
			///	///---Sim 07-04-2007 FIX_IMAGE_SETTING_TREE_NODE_EVENT
			///	//GETN_STRLIST(Preview, "Type", "TIFF", "None|TIFF|Windows Meta File")	GETN_ID(IMG_EPS_PREVIEW)  GETN_OPTION_EVENT(_gui_export_options_eps_event)
			///	GETN_STRLIST(Preview, "Type", "TIFF", "None|TIFF|Windows Meta File")	GETN_ID(IMG_EPS_PREVIEW)  GETN_OPTION_EVENT_EX(_gui_export_options_eps_event)
			///	///---END FIX_IMAGE_SETTING_TREE_NODE_EVENT
			///	/// end USE_CORRECT_KEY_NAMES_USED_BY_OIMG
			/// Hong 10/25/07 QA80-10577 MORE_COMBO_STR_STAY_AS_E_INTERNALLY_IN_DYNA_CNTRL
			//GETN_STRLIST(Preview, _L("Preview"), "TIFF", "None|TIFF|WMF")	GETN_ID(IMG_EPS_PREVIEW)  GETN_OPTION_EVENT_EX(_gui_export_options_eps_event)			
			GETN_STRLIST_L(Preview, _L("Preview"), "TIFF", _LE("None|TIFF|WMF"))	GETN_ID(IMG_EPS_PREVIEW)  GETN_OPTION_EVENT_EX(_gui_export_options_eps_event)
			/// end MORE_COMBO_STR_STAY_AS_E_INTERNALLY_IN_DYNA_CNTRL
			/// end USE_CORRECT_KEY_NAMES_USED_BY_OIMG

			GETN_LIST(Resolution, _L("Resolution"), 1, _L("Low|Medium|High"))	GETN_ID(IMG_EPS_RESOLUTION)
			GETN_LIST(Compression, _L("Compression"), 1, _L("None|PackBits|LZW"))	GETN_ID(IMG_EPS_COMPRESSION)
		///---Sim 08-09-2007 MAKE_EPS_INI_SETING_SAME_AS_75
		//GETN_END_BRANCH(PreviewType)	
		GETN_END_BRANCH(Preview)
		///---END MAKE_EPS_INI_SETING_SAME_AS_75
		
		GETN_BEGIN_BRANCH(Fonts, _L("Fonts"))	GETN_ID_BRANCH(IMG_EPS_FONTS_BRANCH)
			GETN_COMBO(FontType, _L("Adobe Type"), 1, "1|3|42")	GETN_ID(IMG_EPS_FONTTYPE)
			//GETN_LIST(Embed, "Embedding", 2, "Use Substitution|Use Built-In Fonts|Use Outline Fonts")	GETN_ID(IMG_EPS_EMBED)
			GETN_RADIO_INDEX(Embed, 2, _L("Use Substitution|Use Built-In Fonts|Use Outline Fonts"))	GETN_ID(IMG_EPS_EMBED)

			/// EJP 2006-10-03 v8.0493 USE_CORRECT_KEY_NAMES_USED_BY_OIMG
			///GETN_CHECK(TureType, "Always Use True Type", 0)	GETN_ID(IMG_EPS_TRUETYPE)
			///GETN_COMBO(VectorFontThichness, "Vector Thickness", 0.24, "|0.2|0.5|1|1.5|2")	GETN_ID(IMG_EPS_VECTORFONTTHICKNESS)
			GETN_CHECK(TrueType, _L("Always Use True Type"), 0)	GETN_ID(IMG_EPS_TRUETYPE)
			GETN_COMBO(VectorFontThickness, _L("Vector Thickness"), 0.24, "|0.2|0.5|1|1.5|2")	GETN_ID(IMG_EPS_VECTORFONTTHICKNESS)
			/// end USE_CORRECT_KEY_NAMES_USED_BY_OIMG

		GETN_END_BRANCH(Fonts)	
	GETN_END_BRANCH(EPS)
	tr.EPS.SetAttribute(STR_ATTRIB_IMAGE_TYPE, "EPS");
}
///Arvin 04/13/07 v8.0600 IMPROVE_SPEED_FOR_EXPORT_GRAPH
//static void	_gui_update_export_options_for_jpg(TreeNode& tr)
void	gui_update_export_options_for_jpg(TreeNode& tr)
///end IMPROVE_SPEED_FOR_EXPORT_GRAPH
{
	if(!tr.IsValid())
		return;
	
	GETN_USE(tr)
	GETN_BEGIN_BRANCH(JPG, _L("JPG Options"))	GETN_ID_BRANCH(DLG_JPG_OPTIONS)  GETN_OPTION_BRANCH(GETNBRANCH_OPEN)
	
		GETN_COMBO(DotsPerInch, _L("DPI Resolution"), 300, "|72|96|100|150|300|600|1200")	GETN_ID(IMG_JPG_DOTS_PER_INCH)	
		/// Iris 12/04/06 FIX_GRAY_SCALE_FAIL_TO_WORK
		//GETN_COMBO(BitsPerPixel, "Color Depth", 24, "8|24")	GETN_ID(IMG_JPG_BITS_PER_PIXEL)
		//----- CPY 10/23/2007 QA70-10577 COMBO_STR_STAY_AS_E_INTERNALLY_IN_DYNA_CNTRL
		//GETN_STRLIST(BitsPerPixel, _L("Color Depth"), "True Color", "True Color|8-bit Gray Scale") 	GETN_ID(IMG_JPG_BITS_PER_PIXEL)
		GETN_COLOR_DEPATH_TRUE_8GRAY GETN_ID(IMG_JPG_BITS_PER_PIXEL)
		//----- end COMBO_STR_STAY_AS_E_INTERNALLY_IN_DYNA_CNTRL
		///end FIX_GRAY_SCALE_FAIL_TO_WORK
		GETN_SLIDEREDIT(Compression, _L("Compression"), 0, "0|255|255")		GETN_ID(IMG_JPG_COMPRESSION)
	GETN_END_BRANCH(JPG)
	tr.JPG.SetAttribute(STR_ATTRIB_IMAGE_TYPE, "JPG");
}

/// EJP 2006-10-03 v8.0493 USE_CORRECT_KEY_NAMES_USED_BY_OIMG
///---Sim 07-04-2007 FIX_IMAGE_SETTING_TREE_NODE_EVENT
//static bool _gui_tif_event(TreeNode& trGetN, int nRow, int nCntrlType, Dialog& getNDlg)
static bool _gui_tif_event(TreeNode& tr, int nRow, int nCol, TreeNode& trNode, DWORD nEventInfo, int nCntrlType, WndContainer& getNContainer)
///---END FIX_IMAGE_SETTING_TREE_NODE_EVENT
{
	///---Sim 07-04-2007 FIX_IMAGE_SETTING_TREE_NODE_EVENT
	//TreeNode trBitsPerPixel = tree_get_node_by_id(trGetN, IMG_TIF_DEPTH, true);
	TreeNode trBitsPerPixel = tree_get_node_by_id(tr, IMG_TIF_DEPTH, true);
	///---END FIX_IMAGE_SETTING_TREE_NODE_EVENT
	if( !trBitsPerPixel )
		return false;
	TreeNode trTIF = trBitsPerPixel.Parent();
	if( !trTIF )
		return false;
	
	/// Iris 11/03/06 SAME_AS_75
	if("RGB" == trTIF.ColorSpace.strVal)
	{
		trBitsPerPixel.Enable = true;
	}
	else//CMYK and YCbCr
	{
		trBitsPerPixel.Enable = false;
		trBitsPerPixel.strVal = "24-bit Color";
	}
	///End SAME_AS_75
	
	/// Iris 12/04/06 FIX_GRAY_SCALE_FAIL_TO_WORK
	//trTIF.GrayScale.Enable = (trBitsPerPixel.nVal == 8) ? true : false;
	///end FIX_GRAY_SCALE_FAIL_TO_WORK
	return true;	
}
/// end USE_CORRECT_KEY_NAMES_USED_BY_OIMG
///Arvin 04/13/07 v8.0600 IMPROVE_SPEED_FOR_EXPORT_GRAPH
//static void _gui_update_export_options_for_tif(TreeNode& tr) //TIF image settings
void gui_update_export_options_for_tif(TreeNode& tr) //TIF image settings
///end IMPROVE_SPEED_FOR_EXPORT_GRAPH
{
	if(!tr.IsValid())
		return;
	
	GETN_USE(tr)
	GETN_BEGIN_BRANCH(TIF, _L("TIF Options"))	GETN_ID_BRANCH(DLG_TIF_OPTIONS)  GETN_OPTION_BRANCH(GETNBRANCH_OPEN)

		/// EJP 2006-10-03 v8.0493 USE_CORRECT_KEY_NAMES_USED_BY_OIMG
		///	GETN_COMBO(DPI, "DPI Resolution", 150, "72|100|150|300|600|1200")	GETN_ID(IMG_TIF_DPI)
		///	GETN_STRLIST(Space, "Color Space", "RGB", "RGB|CMYK|YCbCr")	GETN_ID(IMG_TIF_SPACE)
		///	GETN_STRLIST(Depth, "Color Depth", "256 Colors", "Monochrome|16 Colors|256 Colors|True Color|8-bit Gray Scale")	GETN_ID(IMG_TIF_DEPTH)
		GETN_COMBO(DotsPerInch, _L("DPI Resolution"), 300, "|72|96|100|150|300|600|1200")	GETN_ID(IMG_TIF_DPI)
		///---Sim 07-04-2007 FIX_IMAGE_SETTING_TREE_NODE_EVENT
		//GETN_STRLIST(ColorSpace, "Color Space", "RGB", "RGB|CMYK|YCbCr")	GETN_ID(IMG_TIF_SPACE) GETN_OPTION_EVENT(_gui_tif_event)
		/// Hong 10/25/07 QA80-10577 MORE_COMBO_STR_STAY_AS_E_INTERNALLY_IN_DYNA_CNTRL
		//GETN_STRLIST(ColorSpace, _L("Color Space"), "RGB", "RGB|CMYK|YCbCr")	GETN_ID(IMG_TIF_SPACE) GETN_OPTION_EVENT_EX(_gui_tif_event)
		GETN_STRLIST_L(ColorSpace, _L("Color Space"), "RGB", "RGB|CMYK|YCbCr")	GETN_ID(IMG_TIF_SPACE) GETN_OPTION_EVENT_EX(_gui_tif_event)
		/// end MORE_COMBO_STR_STAY_AS_E_INTERNALLY_IN_DYNA_CNTRL
		///---END FIX_IMAGE_SETTING_TREE_NODE_EVENT
		
		/// Iris 12/04/06 FIX_GRAY_SCALE_FAIL_TO_WORK
		//GETN_COMBO(BitsPerPixel, "Color Depth", 8, "1|4|8|24")	GETN_ID(IMG_TIF_DEPTH) GETN_OPTION_EVENT(_gui_tif_event)
		//GETN_CHECK(GrayScale, "Gray Scale", 0)	GETN_ID(IMG_TIF_GRAYSCALE)
		///---Sim 07-04-2007 FIX_IMAGE_SETTING_TREE_NODE_EVENT
		//GETN_STRLIST(BitsPerPixel, "Color Depth", "256 Colors", "Monochrome|16 Colors|256 Colors|True Color|8-bit Gray Scale")	GETN_ID(IMG_TIF_DEPTH) GETN_OPTION_EVENT(_gui_tif_event)
		//----- CPY 10/23/2007 QA70-10577 COMBO_STR_STAY_AS_E_INTERNALLY_IN_DYNA_CNTRL 
		//GETN_STRLIST(BitsPerPixel, _L("Color Depth"), "256 Colors", "Monochrome|16 Colors|256 Colors|True Color|8-bit Gray Scale")	GETN_ID(IMG_TIF_DEPTH) GETN_OPTION_EVENT_EX(_gui_tif_event)
		GETN_COLOR_DEPATH_TRUECOLOR	GETN_ID(IMG_TIF_DEPTH) GETN_OPTION_EVENT_EX(_gui_tif_event)
		//----- end COMBO_STR_STAY_AS_E_INTERNALLY_IN_DYNA_CNTRL 
		///---END FIX_IMAGE_SETTING_TREE_NODE_EVENT
		///end FIX_GRAY_SCALE_FAIL_TO_WORK
		
		/// end USE_CORRECT_KEY_NAMES_USED_BY_OIMG
		/// Hong 10/25/07 QA80-10577 MORE_COMBO_STR_STAY_AS_E_INTERNALLY_IN_DYNA_CNTRL
		//GETN_STRLIST(Compression, _L("Compression"), "None", "None|PackBits|LZW")	GETN_ID(IMG_TIF_COMPRESSION)
		GETN_STRLIST_L(Compression, _L("Compression"), "None", _LE("None|PackBits|LZW"))	GETN_ID(IMG_TIF_COMPRESSION)
		/// end MORE_COMBO_STR_STAY_AS_E_INTERNALLY_IN_DYNA_CNTRL
	GETN_END_BRANCH(TIF)
	tr.TIF.SetAttribute(STR_ATTRIB_IMAGE_TYPE, "TIF");
}
///Arvin 04/13/07 v8.0600 IMPROVE_SPEED_FOR_EXPORT_GRAPH
//static void _gui_update_export_options_for_bmp(TreeNode& tr) //BMP image settings
void 	gui_update_export_options_for_bmp(TreeNode& tr) //BMP image settings
///end IMPROVE_SPEED_FOR_EXPORT_GRAPH
{
	if(!tr.IsValid())
		return;
	
	GETN_USE(tr)
	GETN_BEGIN_BRANCH(BMP, _L("BMP Options"))	GETN_ID_BRANCH(DLG_BMP_OPTIONS)  GETN_OPTION_BRANCH(GETNBRANCH_OPEN)
		GETN_COMBO(DotsPerInch, _L("DPI Resolution"), 300, "|72|96|100|150|300|600|1200")	GETN_ID(IMG_BMP_DPI)
		/// Iris 12/04/06 FIX_GRAY_SCALE_FAIL_TO_WORK
		//GETN_COMBO(BitsPerPixel, "Color Depth", 8, "1|4|8|24")	GETN_ID(IMG_BMP_DEPTH)
		///---Sim 08-01-2007 ADD_MORE_COLOR_BIT_FOR_EXPORT_IMAGE
		//GETN_STRLIST(BitsPerPixel, "Color Depth", "256 Colors", "Monochrome|16 Colors|256 Colors|8-bit Gray Scale")	GETN_ID(IMG_BMP_DEPTH)
		//----- CPY 10/23/2007 QA70-10577 COMBO_STR_STAY_AS_E_INTERNALLY_IN_DYNA_CNTRL 
		//GETN_STRLIST(BitsPerPixel, _L("Color Depth"), "256 Colors", "Monochrome|16 Colors|256 Colors|65536 Colors|True Color|8-bit Gray Scale|")	GETN_ID(IMG_BMP_DEPTH)
		GETN_COLOR_DEPATH_65536COLORS	GETN_ID(IMG_BMP_DEPTH)
		//----- end COMBO_STR_STAY_AS_E_INTERNALLY_IN_DYNA_CNTRL
		///---END ADD_MORE_COLOR_BIT_FOR_EXPORT_IMAGE
		///end FIX_GRAY_SCALE_FAIL_TO_WORK
	GETN_END_BRANCH(BMP)
	tr.BMP.SetAttribute(STR_ATTRIB_IMAGE_TYPE, "BMP");
}

/// EJP 2006-11-21 v8.0514 IMPROVE_IMG_EXT_TYPE_UTIL_FUNC
///Arvin 04/13/07 v8.0600 IMPROVE_SPEED_FOR_EXPORT_GRAPH	
//static void _gui_update_export_options_for_gif(TreeNode& tr) // GIF
void gui_update_export_options_for_gif(TreeNode& tr) // GIF
///end IMPROVE_SPEED_FOR_EXPORT_GRAPH
{
	if(!tr.IsValid())
		return;
	
	GETN_USE(tr)
	GETN_BEGIN_BRANCH(GIF, _L("GIF Options"))	GETN_ID_BRANCH(DLG_GIF_OPTIONS)  GETN_OPTION_BRANCH(GETNBRANCH_OPEN)
		//GETN_COMBO(DotsPerInch, "DPI Resolution", 150, "|72|96|100|150|300|600|1200")	GETN_ID(IMG_GIF_DPI)///Iris 12/05/06 NOT_SUPPORT_DPI_FOR_TGA_GIF
		GETN_COMBO(DotsPerInch, _L("DPI Resolution"), 300, "|72|96|100|150|300|600|1200")	GETN_ID(IMG_GIF_DPI)/// Iris 01/24/2007 v8.0547 SUPPORT_DPI_FOR_GIF_TGA_TYPE
		/// Iris 12/04/06 FIX_GRAY_SCALE_FAIL_TO_WORK
		//GETN_COMBO(BitsPerPixel, "Color Depth", 8, "1|4|8")	GETN_ID(IMG_GIF_DEPTH)
		//----- CPY 10/23/2007 QA70-10577 COMBO_STR_STAY_AS_E_INTERNALLY_IN_DYNA_CNTRL
		//GETN_STRLIST(BitsPerPixel, _L("Color Depth"), "256 Colors", "Monochrome|16 Colors|256 Colors|8-bit Gray Scale")	GETN_ID(IMG_GIF_DEPTH)
		GETN_COLOR_DEPATH_BASIC	GETN_ID(IMG_GIF_DEPTH)
		//----- end COMBO_STR_STAY_AS_E_INTERNALLY_IN_DYNA_CNTRL
		///end FIX_GRAY_SCALE_FAIL_TO_WORK
		
	GETN_END_BRANCH(GIF)
	tr.GIF.SetAttribute(STR_ATTRIB_IMAGE_TYPE, "GIF");
}
/// end IMPROVE_IMG_EXT_TYPE_UTIL_FUNC

/// Iris 11/24/06 v8.0515 SUPPORT_MORE_IMAGE_TYPE
///Arvin 04/13/07 v8.0600 IMPROVE_SPEED_FOR_EXPORT_GRAPH
//static void _gui_update_export_options_for_cgm(TreeNode& tr) // CGM
void 	gui_update_export_options_for_cgm(TreeNode& tr) // CGM
///end IMPROVE_SPEED_FOR_EXPORT_GRAPH
{
	if(!tr.IsValid())
		return;
	
	GETN_USE(tr)
	GETN_BEGIN_BRANCH(CGM, _L("CGM Options"))	GETN_ID_BRANCH(DLG_CGM_OPTIONS)  GETN_OPTION_BRANCH(GETNBRANCH_OPEN)
		/// Iris 01/22/2007 v8.0544 FOUND_MISSED_TWO_OPTIONS
		//GETN_STRLIST(Profiles, "Profiles", "MIL-D-28003(CALS)", "MIL-D-28003(CALS)|MIL-D-28003A(CALS)|Lotus Freelance Plus(Ver. 3.01)|Harvard Graphics(Ver. 2.3)|Inso GDSF(Ver. 1.0)|Inso GDSF(Ver. 2.0)|ApplauseII|CoreIDraw")	GETN_ID(IMG_CGM_PROFILES)
		/// Hong 10/25/07 QA80-10577 MORE_COMBO_STR_STAY_AS_E_INTERNALLY_IN_DYNA_CNTRL
		//GETN_STRLIST(Profiles, _L("Profiles"), "Standard Options(ANSI)", "Standard Options(ANSI)|ANSI CGM 3.0|MIL-D-28003(CALS)|MIL-D-28003A(CALS)|Lotus Freelance Plus(Ver. 3.01)|Harvard Graphics(Ver. 2.3)|Inso GDSF(Ver. 1.0)|Inso GDSF(Ver. 2.0)|ApplauseII|CoreIDraw")	GETN_ID(IMG_CGM_PROFILES)
		GETN_STRLIST_L(Profiles, _L("Profiles"), "Standard Options(ANSI)", _LE("Standard Options(ANSI)|ANSI CGM 3.0|MIL-D-28003(CALS)|MIL-D-28003A(CALS)|Lotus Freelance Plus(Ver. 3.01)|Harvard Graphics(Ver. 2.3)|Inso GDSF(Ver. 1.0)|Inso GDSF(Ver. 2.0)|ApplauseII|CoreIDraw"))	GETN_ID(IMG_CGM_PROFILES)
		/// end MORE_COMBO_STR_STAY_AS_E_INTERNALLY_IN_DYNA_CNTRL
		///end FOUND_MISSED_TWO_OPTIONS
		//----- CPY 10/23/2007 QA70-10577 COMBO_STR_STAY_AS_E_INTERNALLY_IN_DYNA_CNTRL
		//GETN_STRLIST(Color, _L("Color Translation"), "Normal", "Normal|Inverse|Inverse Grays Only|Grays Scale|Inverse Gray Scale")	GETN_ID(IMG_CGM_COLOR_TRANSLATE)
		//GETN_STRLIST(Line, _L("Line Mode"), "Device", "Device|Stroked")	GETN_ID(IMG_CGM_LINE_MODE)
		GETN_STRLIST_L(Color, _L("Color Translation"), "Normal", _LE("Normal|Inverse|Inverse Grays Only|Grays Scale|Inverse Gray Scale"))	GETN_ID(IMG_CGM_COLOR_TRANSLATE)
		GETN_STRLIST_L(Line, _L("Line Mode"), "Device", _LE("Device|Stroked"))	GETN_ID(IMG_CGM_LINE_MODE)	
		//----- end COMBO_STR_STAY_AS_E_INTERNALLY_IN_DYNA_CNTRL 
	GETN_END_BRANCH(CGM)
	tr.CGM.SetAttribute(STR_ATTRIB_IMAGE_TYPE, "CGM");
}
///Arvin 04/13/07 v8.0600 IMPROVE_SPEED_FOR_EXPORT_GRAPH
//static void _gui_update_export_options_for_dxf(TreeNode& tr) // DXF
void gui_update_export_options_for_dxf(TreeNode& tr) // DXF
///end IMPROVE_SPEED_FOR_EXPORT_GRAPH
{
	if(!tr.IsValid())
		return;
	
	GETN_USE(tr)
	GETN_BEGIN_BRANCH(DXF, _L("DXF Options"))	GETN_ID_BRANCH(DLG_DXF_OPTIONS)  GETN_OPTION_BRANCH(GETNBRANCH_OPEN)
		//----- CPY 10/23/2007 QA70-10577 COMBO_STR_STAY_AS_E_INTERNALLY_IN_DYNA_CNTRL
		//GETN_STRLIST(Profiles, _L("Profiles"), "Standard Options (Text DXF)", "Standard Options (Text DXF)|Binary DXF")	GETN_ID(IMG_DXF_PROFILES)
		//GETN_STRLIST(Color, _L("Color Translation"), "Normal", "Normal|Inverse|Inverse Grays Only|Grays Scale|Inverse Gray Scale")	GETN_ID(IMG_DXF_COLOR_TRANSLATE)
		//GETN_STRLIST(Units, _L("DXF File Units"), "Inches", "Inches|Feet|Yards|Miles|MMeters|CMeters|Meters|KMeters")	GETN_ID(IMG_DXF_UNITS)	
		GETN_STRLIST_L(Profiles, _L("Profiles"), "Standard Options (Text DXF)", _LE("Standard Options (Text DXF)|Binary DXF"))	GETN_ID(IMG_DXF_PROFILES)
		GETN_STRLIST_L(Color, _L("Color Translation"), "Normal", _LE("Normal|Inverse|Inverse Grays Only|Grays Scale|Inverse Gray Scale"))	GETN_ID(IMG_DXF_COLOR_TRANSLATE)
		GETN_STRLIST_L(Units, _L("DXF File Units"), "Inches", _LE("Inches|Feet|Yards|Miles|MMeters|CMeters|Meters|KMeters"))	GETN_ID(IMG_DXF_UNITS)	
		//----- end COMBO_STR_STAY_AS_E_INTERNALLY_IN_DYNA_CNTRL
	tr.DXF.SetAttribute(STR_ATTRIB_IMAGE_TYPE, "DXF");	
}


///Arvin 04/13/07 v8.0600 IMPROVE_SPEED_FOR_EXPORT_GRAPH
//static void _gui_update_export_options_for_pcx(TreeNode& tr) // PCX
void gui_update_export_options_for_pcx(TreeNode& tr) // PCX
///end IMPROVE_SPEED_FOR_EXPORT_GRAPH
{
	if(!tr.IsValid())
		return;
	
	GETN_USE(tr)
	GETN_BEGIN_BRANCH(PCX, _L("PCX Options"))	GETN_ID_BRANCH(DLG_PCX_OPTIONS)  GETN_OPTION_BRANCH(GETNBRANCH_OPEN)
		GETN_COMBO(DotsPerInch, _L("DPI Resolution"), 300, "|72|100|150|300|600|1200")	GETN_ID(IMG_PCX_DPI)
		/// Iris 12/04/06 FIX_GRAY_SCALE_FAIL_TO_WORK
		//GETN_COMBO(BitsPerPixel, "Color Depth", 8, "1|4|8")	GETN_ID(IMG_PCX_DEPTH)
		//----- CPY 10/23/2007 QA70-10577 COMBO_STR_STAY_AS_E_INTERNALLY_IN_DYNA_CNTRL
		//GETN_STRLIST(BitsPerPixel, _L("Color Depth"), "256 Colors", "Monochrome|16 Colors|256 Colors|True Color|8-bit Gray Scale")	GETN_ID(IMG_PCX_DEPTH)
		GETN_COLOR_DEPATH_TRUECOLOR	GETN_ID(IMG_PCX_DEPTH)
		//----- end COMBO_STR_STAY_AS_E_INTERNALLY_IN_DYNA_CNTRL
		///end FIX_GRAY_SCALE_FAIL_TO_WORK
	GETN_END_BRANCH(PCX)
	tr.PCX.SetAttribute(STR_ATTRIB_IMAGE_TYPE, "PCX");
}
///Arvin 04/13/07 v8.0600 IMPROVE_SPEED_FOR_EXPORT_GRAPH
//static void _gui_update_export_options_for_png(TreeNode& tr) // PNG
void gui_update_export_options_for_png(TreeNode& tr) // PNG
///end IMPROVE_SPEED_FOR_EXPORT_GRAPH
{
	if(!tr.IsValid())
		return;
	
	GETN_USE(tr)
	GETN_BEGIN_BRANCH(PNG, _L("PNG Options"))	GETN_ID_BRANCH(DLG_PNG_OPTIONS)  GETN_OPTION_BRANCH(GETNBRANCH_OPEN)
		GETN_COMBO(DotsPerInch, _L("DPI Resolution"), 300, "|72|100|150|300|600|1200")	GETN_ID(IMG_PNG_DPI)
		/// Iris 12/04/06 FIX_GRAY_SCALE_FAIL_TO_WORK
		//GETN_COMBO(BitsPerPixel, "Color Depth", 8, "1|4|8")	GETN_ID(IMG_PNG_DEPTH)
		//----- CPY 10/23/2007 QA70-10577 COMBO_STR_STAY_AS_E_INTERNALLY_IN_DYNA_CNTRL
		//GETN_STRLIST(BitsPerPixel, _L("Color Depth"), "256 Colors", "Monochrome|16 Colors|256 Colors|True Color|8-bit Gray Scale")	GETN_ID(IMG_PNG_DEPTH)
		GETN_COLOR_DEPATH_TRUECOLOR GETN_ID(IMG_PNG_DEPTH)
		//----- end COMBO_STR_STAY_AS_E_INTERNALLY_IN_DYNA_CNTRL
		///end FIX_GRAY_SCALE_FAIL_TO_WORK
		GETN_NUM(Compression, _L("Compression"), 0) GETN_ID(IMG_PNG_COMPRESSION)
	GETN_END_BRANCH(PNG)
	tr.PNG.Compression.Show = false; //same as 75, not this option on dialog, but have it in OMIG fie
	tr.PNG.SetAttribute(STR_ATTRIB_IMAGE_TYPE, "PNG");
}
///Arvin 04/13/07 v8.0600 IMPROVE_SPEED_FOR_EXPORT_GRAPH
//static void _gui_update_export_options_for_tga(TreeNode& tr) // TGA
void gui_update_export_options_for_tga(TreeNode& tr) // TGA
///end IMPROVE_SPEED_FOR_EXPORT_GRAPH
{
	if(!tr.IsValid())
		return;
	
	GETN_USE(tr)
	GETN_BEGIN_BRANCH(TGA, _L("TGA Options"))	GETN_ID_BRANCH(DLG_TGA_OPTIONS)  GETN_OPTION_BRANCH(GETNBRANCH_OPEN)
		//GETN_COMBO(DotsPerInch, "DPI Resolution", 150, "|72|100|150|300|600|1200")	GETN_ID(IMG_TGA_DPI) ///Iris 12/05/06 NOT_SUPPORT_DPI_FOR_TGA_GIF
		GETN_COMBO(DotsPerInch, _L("DPI Resolution"), 300, "|72|100|150|300|600|1200")	GETN_ID(IMG_TGA_DPI)/// Iris 01/24/2007 v8.0547 SUPPORT_DPI_FOR_GIF_TGA_TYPE
		/// Iris 12/04/06 FIX_GRAY_SCALE_FAIL_TO_WORK
		//GETN_COMBO(BitsPerPixel, "Color Depth", 8, "8|16|24")	GETN_ID(IMG_TGA_DEPTH)
		//----- CPY 10/23/2007 QA70-10577 COMBO_STR_STAY_AS_E_INTERNALLY_IN_DYNA_CNTRL
		//GETN_STRLIST(BitsPerPixel, _L("Color Depth"), "256 Colors", "256 Colors|65536 Colors|True Color|8-bit Gray Scale")	GETN_ID(IMG_TGA_DEPTH)
		GETN_COLOR_DEPATH_65536COLORS_NOMONO	GETN_ID(IMG_TGA_DEPTH)
		//-----
		///end FIX_GRAY_SCALE_FAIL_TO_WORK		
		GETN_NUM(Compression, _L("Compression"), 0) GETN_ID(IMG_TGA_COMPRESSION)
	GETN_END_BRANCH(TGA)
	tr.TGA.Compression.Show = false; //same as 75, not this option on dialog, but have it in OMIG fie
	tr.TGA.SetAttribute(STR_ATTRIB_IMAGE_TYPE, "TGA");
}
///Arvin 04/13/07 v8.0600 IMPROVE_SPEED_FOR_EXPORT_GRAPH
//static void _gui_update_export_options_for_psd(TreeNode& tr) // PSD
void gui_update_export_options_for_psd(TreeNode& tr) // PSD
///end IMPROVE_SPEED_FOR_EXPORT_GRAPH
{
	if(!tr.IsValid())
		return;
	
	GETN_USE(tr)
	GETN_BEGIN_BRANCH(PSD, _L("PSD Options"))	GETN_ID_BRANCH(DLG_PSD_OPTIONS)  GETN_OPTION_BRANCH(GETNBRANCH_OPEN)
		GETN_COMBO(DotsPerInch, _L("DPI Resolution"), 300, "|72|100|150|300|600|1200")	GETN_ID(IMG_PSD_DPI)
		/// Iris 12/04/06 FIX_GRAY_SCALE_FAIL_TO_WORK
		//GETN_COMBO(BitsPerPixel, "Color Depth", 8, "1|8|24")	GETN_ID(IMG_PSD_DEPTH)
		//----- CPY 10/23/2007 QA70-10577 COMBO_STR_STAY_AS_E_INTERNALLY_IN_DYNA_CNTRL
		//GETN_STRLIST(BitsPerPixel, _L("Color Depth"), "256 Colors", "Monochrome|256 Colors|True Color|8-bit Gray Scale")	GETN_ID(IMG_PSD_DEPTH)
		GETN_COLOR_DEPATH_TRUECOLOR_NO16 GETN_ID(IMG_PSD_DEPTH)
		//----- end COMBO_STR_STAY_AS_E_INTERNALLY_IN_DYNA_CNTRL
		///end FIX_GRAY_SCALE_FAIL_TO_WORK			
		GETN_NUM(Compression, _L("Compression"), 0) GETN_ID(IMG_PSD_COMPRESSION)
	GETN_END_BRANCH(PSD)
	tr.PSD.Compression.Show = false; //same as 75, not this option on dialog, but have it in OMIG fie
	tr.PSD.SetAttribute(STR_ATTRIB_IMAGE_TYPE, "PSD");

}
///Arvin 04/13/07 v8.0600 IMPROVE_SPEED_FOR_EXPORT_GRAPH
//static void _gui_update_export_options_for_xpm(TreeNode& tr) // XPM
void gui_update_export_options_for_xpm(TreeNode& tr) // XPM
///end IMPROVE_SPEED_FOR_EXPORT_GRAPH
{
	if(!tr.IsValid())
		return;
	
	GETN_USE(tr)
	GETN_BEGIN_BRANCH(XPM, _L("XPM Options"))	GETN_ID_BRANCH(DLG_XPM_OPTIONS)  GETN_OPTION_BRANCH(GETNBRANCH_OPEN)
		GETN_COMBO(DotsPerInch, _L("DPI Resolution"), 300, "|72|100|150|300|600|1200")	GETN_ID(IMG_XPM_DPI)
		///---Sim 11-30-2006 UNSUPPORT_24_BIT
		//GETN_COMBO(BitsPerPixel, "Color Depth", 8, "1|8|24")	GETN_ID(IMG_XPM_DEPTH)
		GETN_COMBO(BitsPerPixel, _L("Color Depth"), 8, "1|8")	GETN_ID(IMG_XPM_DEPTH)
		///---END UNSUPPORT_24_BIT
		GETN_NUM(Compression, _L("Compression"), 0) GETN_ID(IMG_XPM_COMPRESSION)
	GETN_END_BRANCH(XPM)
	tr.XPM.Compression.Show = false; //same as 75, not this option on dialog, but have it in OMIG fie
	tr.XPM.SetAttribute(STR_ATTRIB_IMAGE_TYPE, "XPM");

}
///Arvin 04/13/07 v8.0600 IMPROVE_SPEED_FOR_EXPORT_GRAPH
//static void _gui_update_export_options_for_xwd(TreeNode& tr) // XWD
void gui_update_export_options_for_xwd(TreeNode& tr) // XWD
///end IMPROVE_SPEED_FOR_EXPORT_GRAPH
{
	if(!tr.IsValid())
		return;
	
	GETN_USE(tr)
	GETN_BEGIN_BRANCH(XWD, _L("XWD Options"))	GETN_ID_BRANCH(DLG_XWD_OPTIONS)  GETN_OPTION_BRANCH(GETNBRANCH_OPEN)
		GETN_COMBO(DotsPerInch, _L("DPI Resolution"), 300, "|72|100|150|300|600|1200")	GETN_ID(IMG_XWD_DPI)
		///---Sim 11-30-2006 UNSUPPORT_24_BIT
		//GETN_COMBO(BitsPerPixel, "Color Depth", 8, "1|8|24")	GETN_ID(IMG_XWD_DEPTH)
		GETN_COMBO(BitsPerPixel, _L("Color Depth"), 8, "1|8")	GETN_ID(IMG_XWD_DEPTH)
		///---END UNSUPPORT_24_BIT
		GETN_NUM(Compression, _L("Compression"), 0) GETN_ID(IMG_XWD_COMPRESSION)
	GETN_END_BRANCH(XWD)
	tr.XWD.Compression.Show = false; //same as 75, not this option on dialog, but have it in OMIG fie
	tr.XWD.SetAttribute(STR_ATTRIB_IMAGE_TYPE, "XWD");

}
///Arvin 04/13/07 v8.0600 IMPROVE_SPEED_FOR_EXPORT_GRAPH
//static void _gui_update_export_options_for_wmf(TreeNode& tr) // WMF
void gui_update_export_options_for_wmf(TreeNode& tr) // WMF
///end IMPROVE_SPEED_FOR_EXPORT_GRAPH
{
	if(!tr.IsValid())
		return;
	
	GETN_USE(tr)
	GETN_BEGIN_BRANCH(WMF, _L("WMF Options"))	GETN_ID_BRANCH(DLG_WMF_OPTIONS)  GETN_OPTION_BRANCH(GETNBRANCH_OPEN)
		GETN_CHECK(Placeable, _L("Placeable"), 1)	GETN_ID(IMG_WMF_DPI)
	GETN_END_BRANCH(WMF)
	tr.WMF.SetAttribute(STR_ATTRIB_IMAGE_TYPE, "WMF");
}	
	
///Arvin 04/13/07 v8.0600 IMPROVE_SPEED_FOR_EXPORT_GRAPH
//static void _gui_update_export_options_for_ai(TreeNode& tr)
void gui_update_export_options_for_ai(TreeNode& tr)
///end IMPROVE_SPEED_FOR_EXPORT_GRAPH
{
	if(!tr.IsValid())
		return;
	
	GETN_USE(tr)
	GETN_BEGIN_BRANCH(AI, _L("AI Options"))	GETN_ID_BRANCH(DLG_AI_OPTIONS)	GETN_OPTION_BRANCH(GETNBRANCH_OPEN)
	
		GETN_LIST(Profile,_L("Profile"),0,_L("Standard Options-AI|Standard Options-EPF"))	GETN_ID(IMG_AI_PROFILE)
		GETN_LIST(ColorTranslation, _L("Color Translation"), 0, _L("Normal|Inverse|Inverse Grays Only|Gray Scale|Inverse Grays Scale"))	GETN_ID(IMG_AI_COLORS)
		GETN_LIST(LineMode,_L("Line Mode"),0,_L("Device|Stroked"))  GETN_ID(IMG_AI_LINEMODE)
		GETN_CHECK(BackGround, _L("BackGround Rectangle"), 0)	GETN_ID(IMG_AI_BACKGROUND)
		GETN_CHECK(Optimize, _L("Optimize for Color Printer"), 0)	GETN_ID(IMG_AI_OPTIMIZE)
		GETN_CHECK(AIFormat, _L("Include AI Format"), 1)	GETN_ID(IMG_AI_AIFORMAT)
		GETN_LIST(AIVERSION,_L("AI Version"),0,"3|5|6|7")  GETN_ID(IMG_AI_AIVERSION)
		
		GETN_BEGIN_BRANCH(TIFF, _L("Include TIFF Preview"))	GETN_CHECKBOX_BRANCH(0) GETN_ID_BRANCH(IMG_AI_TIFF)			
		 	GETN_LIST(Format,_L("Format"),0,_L("Bi-Level|8 Color|16 Gray|16 Color|256 Gray|256 Color|24-bit Color")) GETN_ID_BRANCH(IMG_AI_FORMAT) ///---Sim 08-30-2007 FIX_COLOR_NAME
		 	/// Hong 10/25/07 QA80-10577 MORE_COMBO_STR_STAY_AS_E_INTERNALLY_IN_DYNA_CNTRL
			//GETN_STRLIST(DataCompression, _L("Data Compression"), "None", "None|PackBits|Modify Huffman|LZW")	GETN_ID(IMG_AI_COMPRESSION)
			GETN_STRLIST_L(DataCompression, _L("Data Compression"), "None", _LE("None|PackBits|Modified Huffman|LZW"))	GETN_ID(IMG_AI_COMPRESSION)
			/// end MORE_COMBO_STR_STAY_AS_E_INTERNALLY_IN_DYNA_CNTRL
			
			///---Sim 07-04-2007 FIX_IMAGE_SETTING_TREE_NODE_EVENT
			//GETN_LIST(Resolution, "Resolution",3, "Screen|Printer|Source|Manual")	GETN_ID(IMG_AI_RESOLUTION)  GETN_OPTION_EVENT(_gui_ai_event)
			GETN_LIST(Resolution, _L("Resolution"),3, _L("Screen|Printer|Source|Manual"))	GETN_ID(IMG_AI_RESOLUTION)  GETN_OPTION_EVENT_EX(_gui_ai_event)
			///---END FIX_IMAGE_SETTING_TREE_NODE_EVENT
			GETN_NUM(Length,_L("Length"),72)  GETN_ID(IMG_AI_LENGTH) 
			GETN_NUM(Width,_L("Width"),72)  GETN_ID(IMG_AI_WIDTH)  
		GETN_END_BRANCH(TIFF)
		
	GETN_END_BRANCH(AI)	
	tr.AI.SetAttribute(STR_ATTRIB_IMAGE_TYPE, "AI");
	
}

///---Sim 07-04-2007 FIX_IMAGE_SETTING_TREE_NODE_EVENT
//static bool _gui_ai_event(TreeNode& trGetN, int nRow, int nCntrlType, Dialog& getNDlg)
static bool _gui_ai_event(TreeNode& tr, int nRow, int nCol, TreeNode& trNode, DWORD nEventInfo, int nCntrlType, WndContainer& getNContainer)
///---END FIX_IMAGE_SETTING_TREE_NODE_EVENT
{
	///---Sim 07-04-2007 FIX_IMAGE_SETTING_TREE_NODE_EVENT
	//TreeNode trResolutionType = tree_get_node(trGetN, nRow);
	TreeNode trResolutionType = trNode;
	///---END FIX_IMAGE_SETTING_TREE_NODE_EVENT
	TreeNode trResolution=trResolutionType.Parent();
	if(!trResolutionType || !trResolution)
		return false;
	bool	bEnable = 3 == trResolutionType.nVal? true : false;
	trResolution.Length.Enable=bEnable;
	trResolution.Width.Enable=bEnable;
	return true;
}
///end SUPPORT_MORE_IMAGE_TYPE

/// EJP 2006-10-04 v8.0493 USE_CORRECT_KEY_NAMES_USED_BY_OIMG
bool convert_node_value_from_index_to_str(TreeNode& trNode, LPCSTR lpcszAttrName)
{
	string strTokens;
	if( !trNode.GetAttribute(lpcszAttrName, strTokens) )
		return false;

	string str = trNode.strVal;
	int nIndex = atoi(str);
	
	str = strTokens.GetToken(nIndex, '|');
	trNode.strVal = str;
	return true;
}

bool convert_node_value_from_str_to_index(TreeNode& trNode, LPCSTR lpcszAttrName)
{
	string strTokens;
	if( !trNode.GetAttribute(lpcszAttrName, strTokens) )
		return false;

	string str = trNode.strVal;
	int nIndex = strTokens.FindToken(str, '|');
	
	str.Format("%d", nIndex);
	trNode.strVal = str;
	return true;
}
/// end USE_CORRECT_KEY_NAMES_USED_BY_OIMG

/// Iris 12/04/06 FIX_GRAY_SCALE_FAIL_TO_WORK
bool	convert_color_depth_from_str_to_num(TreeNode& trNode)
{
	if(!trNode)
		return false;

	string strCombo;
	if( !trNode.GetAttribute(STR_COMBO_ATTRIB, strCombo) )
		return false;
	
	int		nNumBits;
	int		nGray = 0;
	string 	str = trNode.strVal;
	if(0 == str.CompareNoCase("Monochrome"))
		nNumBits = 1;
	if(0 == str.CompareNoCase("16 Colors"))
		nNumBits = 4;
	if(0 == str.CompareNoCase("256 Colors"))
	{
		nNumBits = 8;	
		nGray = 0;
	}
	if(0 == str.CompareNoCase("8-bit Gray Scale"))
	{
		nNumBits = 8;
		nGray = 1;
	}
	if(0 == str.CompareNoCase("16-bit Color"))
		nNumBits = 16;	
	if(0 == str.CompareNoCase("24-bit Color"))
		nNumBits = 24;
	
	str.Format("%d", nNumBits);
	trNode.strVal = str;
	trNode.SetAttribute(STR_ATTRIB_GRAY_SCALE, nGray);	
	
	return true;	
}

bool	convert_color_depth_from_num_to_str(TreeNode& trNode)
{	
	if(!trNode)
		return false;
	
	string strCombo;
	if( !trNode.GetAttribute(STR_COMBO_ATTRIB, strCombo) )
		return false;
	
	string 	str = trNode.strVal;
	int 	nNumBits = atoi(str);
	
	int		nTemp = 0;
	switch(nNumBits)
	{
	case 1:
		str = "Monochrome";
		break;
	case 4:
		str = "16 Colors";
		break;
	case 8:		
		if(trNode.GetAttribute(STR_ATTRIB_GRAY_SCALE, nTemp))
			str = 1 == nTemp? "8-bit Gray Scale" : "256 Colors";
		else
		{
			str = "8-bit Gray Scale";
			if(strCombo.Find(str) < 0)
				str = "256 Colors";
		}
		break;
	case 16:
		str = "16-bit Color";
		break;
	case 24:
		str = "24-bit Color";
		break;
	}
		
	trNode.strVal = str;
	return true;		
	
}
///end FIX_GRAY_SCALE_FAIL_TO_WORK
///Arvin 04/13/07 v8.0600 IMPROVE_SPEED_FOR_EXPORT_GRAPH
//static void _gui_update_export_options_for_pdf(TreeNode& tr)
void gui_update_export_options_for_pdf(TreeNode& tr)
///end IMPROVE_SPEED_FOR_EXPORT_GRAPH
{
	if(!tr.IsValid())
		return;
	
	GETN_USE(tr)
	GETN_BEGIN_BRANCH(PDF, _L("PDF Options"))	GETN_ID_BRANCH(DLG_PDF_OPTIONS)
		
		GETN_BEGIN_BRANCH(pdf,_L("Basic Object")) GETN_ID_BRANCH(IMG_PDF_BASEOBJECT_BRANCH) GETN_OPTION_BRANCH(GETNBRANCH_OPEN)
			GETN_LIST(ColorTranslation, _L("Color Translation"), 0, _L("Normal|Inverse|Inverse Grays Only|Gray Scale|Inverse Grays Scale"))	GETN_ID(IMG_PDF_COLORS)
			GETN_LIST(LineMode,_L("Line Mode"),0,_L("Device|Stroked"))  GETN_ID(IMG_PDF_LINEMODE)
			GETN_LIST(FillMode,_L("Fill Mode"),0,_L("Device|Stroked"))  GETN_ID(IMG_PDF_FILLMODE)
			GETN_CHECK(BackGround, _L("BackGround Rectangle"), 0)	GETN_ID(IMG_PDF_BACKGROUND)
		//GETN_END_BRANCH(pdf)
		
		//GETN_BEGIN_BRANCH(Raster,"Raster Objects") GETN_ID_BRANCH(IMG_PDF_RASTER) GETN_OPTION_BRANCH(GETNBRANCH_OPEN)
			GETN_LIST(DestRastOper, _L("Handling"), 2, _L("Ignore|Source Copy|Individual Bitmaps|Combine All Bitmaps"))	GETN_ID(IMG_PDF_DESTRASTOPER)
			/// Iris 11/14/06 v8.0510 KEEP_ADVAN_FAIL_TO_WORK_FOR_PDF
			//GETN_COMBO(DestRastOperRes, "Resolution", 72, "72|96|100|150|300|600")	GETN_ID(IMG_PDF_DESTRASTOPERRES)
			///end KEEP_ADVAN_FAIL_TO_WORK_FOR_PDF
			GETN_COMBO(DestRastOperRes, _L("Resolution"), 72, "72|96|100|150|300|600")	GETN_ID(IMG_PDF_DESTRASTOPERRES) /// Iris 07/12/2007 PAGE_RESOLUTION_SHOULD_BE_DIFF_WITH_IMAGE_RESOLUTION
		GETN_END_BRANCH(pdf)
		
		GETN_BEGIN_BRANCH(Compression,_L("Data Compression")) GETN_ID_BRANCH(IMG_PDF_COMPRESSION_BRANCH)
			GETN_LIST(ClrImageCompression,_L("Color Images"),0,_L("None|JPEG High|JPEG High-Medium|JPEG Medium|JPEG Medium-Low|JPEG Low|Flate"))  GETN_ID(IMG_PDF_CLRIMAGECOMPRESSION)
			GETN_LIST(MnImageCompression,_L("Monochrome Images"),0,_L("None|CCITT Group 3|CCITT Group 4|Run-Length Encoded|Flate"))  GETN_ID(IMG_PDF_MNIMAGECOMPRESSION)
			GETN_LIST(TextCompression,_L("Graphics and Text"),0,_L("None|Flate")) GETN_ID(IMG_PDF_TEXTCOMPRESSION)
			GETN_CHECK(ASCIIEncoding, _L("ASCII Encoding"), 0)	GETN_ID(IMG_PDF_ASCIIENCODING)
		GETN_END_BRANCH(Compression)
		
		GETN_BEGIN_BRANCH(Font,_L("Fonts")) GETN_ID_BRANCH(IMG_PDF_FONT)
			GETN_RADIO_INDEX(Embed, 0, _L("Descriptor Only|Embedded|Outline"))	GETN_ID(IMG_PDF_EMBED)
			GETN_LIST(OutLineMode,_L("OutLine Mode"),0,_L("Compact|Adobe Type 3")) GETN_ID(IMG_PDF_OUTLINE)
			GETN_LIST(StrokeWidth,_L("Stroke Width"),2,_L("Thin|Normal|Semi-Bold|Bold"))  GETN_ID(IMG_PDF_STROKEWIDTH)
			GETN_CHECK(FontSubstitution, _L("Font Substitution"), 0)	GETN_ID(IMG_PDF_SUBSTITUTION)
			GETN_CHECK(TrueType, _L("Use True Type"), 0)	GETN_ID(IMG_PDF_TRUETYPE)
		GETN_END_BRANCH(Font)		
	GETN_END_BRANCH(PDF)
	
	tr.PDF.SetAttribute(STR_ATTRIB_IMAGE_TYPE, "PDF");
	
	///Alex/Iris 11/10/06 FIX_COLOR_TRANSLATION_FOR_PDF
	tr.PDF.pdf.ColorTranslation.SetAttribute(STR_COMPLEX_ININAME_ATTRIBUTE, 1); 
	tr.PDF.Font.FontSubstitution.SetAttribute(STR_COMPLEX_ININAME_ATTRIBUTE, 1); 
	///end FIX_COLOR_TRANSLATION_FOR_PDF	
}
///end MOVE_EXPORT_PAGE_CODE_AS_GLOBAL_FROM_XF

/// EJP 2007-02-01 v8.0553 QA70-9329 FILE_EXT_GRP_ALL_TYPES
static int get_file_group_types(StringArray& saTypes, LPCSTR lpcszGroup)
{
	string str;
	str.Format("System.FileExt.ActiveGroup$=%s;", lpcszGroup);
	LT_execute(str);

	double dValue;
	LT_get_var("System.FileExt.NumTypes", &dValue);
	int nNumTypes = (int)dValue;

	char szType[MAXFULLPATH];
	for( int nType = 1; nType <= nNumTypes; nType++ )
	{
		str.Format("System.FileExt.Type%d$", nType);
		if( LT_get_str(str, szType, MAXFULLPATH) )
			saTypes.Add(szType);
	}
	return saTypes.GetSize();
}
bool get_file_group_alltypes(string& strAllTypes, StringArray& saTypes, LPCSTR lpcszNewType) // = NULL
{
	string str, strExt, strAllExts;
	for( int nType = 0; nType < saTypes.GetSize(); nType++ )
	{
		if( _get_file_type_parts(str, strExt, saTypes[nType]) )
			continue;
		if( !strAllExts.IsEmpty() )
			strAllExts += ";";
		strAllExts += strExt;
	}
	
	if( lpcszNewType )
		str = lpcszNewType;
	else
		str = _L("All Types");

	strAllTypes.Format("[%s (%s)] %s", str, strAllExts, strAllExts);
	return true;
}
bool get_file_group_alltypes(string& strAllTypes, LPCSTR lpcszGroup, LPCSTR lpcszNewType) // = NULL
{
	StringArray saTypes;
	if( 0 == get_file_group_types(saTypes, lpcszGroup) )
		return false;
	if( NULL == lpcszNewType )
		lpcszNewType = lpcszGroup;
	return get_file_group_alltypes(strAllTypes, saTypes, lpcszNewType);
}
/// end FILE_EXT_GRP_ALL_TYPES

///Sandy 2007-3-9 move from XF img2gif
int save_ml_to_gif(MatrixLayer& ml, string& fname)
{
	HBITMAPLIST hList; 
	int nRet;
	
	nRet = L_CreateBitmapList(&hList);
	
	BITMAPHANDLE TmpBmp;
	pBITMAPHANDLE phBmp;
	
	foreach(MatrixObject mo in ml.MatrixObjects)
	{
		Image imgi(mo);
		phBmp = imgi.GetLBmp();
		nRet = L_CopyBitmap(&TmpBmp, phBmp, sizeof(BITMAPHANDLE));
		nRet = L_ColorResBitmap(&TmpBmp, &TmpBmp, sizeof(BITMAPHANDLE), 8,
							CRF_FLOYDSTEINDITHERING|CRF_OPTIMIZEDPALETTE,  NULL, NULL, 0, NULL, NULL );
		
	
		if (TmpBmp.Width > MAX_SIZE_OF_GIF_IMAGE)
			nRet =L_SizeBitmap (&TmpBmp, MAX_SIZE_OF_GIF_IMAGE, (TmpBmp.Height * MAX_SIZE_OF_GIF_IMAGE) / TmpBmp.Width, SIZE_RESAMPLE);
		else if (TmpBmp.Height > MAX_SIZE_OF_GIF_IMAGE)
			nRet =L_SizeBitmap (&TmpBmp, (TmpBmp.Width * MAX_SIZE_OF_GIF_IMAGE) / TmpBmp.Height, MAX_SIZE_OF_GIF_IMAGE, SIZE_RESAMPLE);
	
	    
		nRet = L_InsertBitmapListItem(hList, (L_UINT)-1, &TmpBmp);
		
	
	}
	
	SAVEFILEOPTION SaveFileOption; // File options when saving 
	nRet = L_GetDefaultSaveFileOption(&SaveFileOption, sizeof(SAVEFILEOPTION));
	if(nRet < MAX_ERROR_CODE_FROM_LT)
		return nRet;	
	
	
	nRet = L_GetBitmapColors(&TmpBmp, 0, 256, SaveFileOption.GlobalPalette);
	if(nRet < MAX_ERROR_CODE_FROM_LT)
		return nRet;	 
	
	SaveFileOption.Flags = ESO_GLOBALLOOP|ESO_GLOBALBACKGROUND|ESO_GLOBALPALETTE;// 
	SaveFileOption.GlobalWidth = TmpBmp.Width;
	SaveFileOption.GlobalHeight = TmpBmp.Height;
	SaveFileOption.GlobalLoop = 0;
	SaveFileOption.GlobalBackground = TmpBmp.Background;
	
	//
	nRet = L_SaveBitmapList(fname.GetBuffer(fname.GetLength()), hList, FILE_GIF, 8, 0, &SaveFileOption);
	if(nRet < MAX_ERROR_CODE_FROM_LT)
		return nRet;
	
	nRet = L_DestroyBitmapList(hList);
	if(nRet < MAX_ERROR_CODE_FROM_LT)
		return nRet;
	
	return 0;
}
//end
